/*
Copyright (C) 2010 Ronie Salgado

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#include "stdafx.h"
#include "QViewPanel.h"
#include "QView.h"
#include "QMainFrame.h"

BEGIN_EVENT_TABLE(QViewPanel, wxPanel)
	EVT_ACTIVATE(QViewPanel::OnActivate)
	EVT_SIZE(QViewPanel::OnSize)
	EVT_PAINT(QViewPanel::OnPaint)
	EVT_ENTER_WINDOW(QViewPanel::OnMouseEnter)
	EVT_CLOSE(QViewPanel::OnCloseWindow)
END_EVENT_TABLE()

QViewPanel::QViewPanel(QView *view, wxWindow *parent,
			wxWindowID id, const wxString &title)
{
	Create(view, parent, id, title);
}

QViewPanel::~QViewPanel()
{
	childView = NULL;
}

bool QViewPanel::Create(QView *view, wxWindow *parent, wxWindowID id, const wxString &title)
{
	childView = view;
	childTitle = title;

	if(wxPanel::Create(parent, id))
	{
		if(view)
			view->SetFrame(this);
		return true;
	}

	return false;
}

bool QViewPanel::ProcessEvent(wxEvent& event)
{
    static wxEvent *ActiveEvent = NULL;

    // Break recursion loops
    if (ActiveEvent == &event)
        return false;

    ActiveEvent = &event;

    bool ret;
    if ( !childView || !childView->ProcessEvent(event) )
    {
    	// Only hand up to the parent if it's a menu command
        if (!event.IsKindOf(CLASSINFO(wxCommandEvent)) || !GetParent() || !GetParent()->ProcessEvent(event))
            ret = wxEvtHandler::ProcessEvent(event);
        else
            ret = true;
    }
    else
        ret = true;

    ActiveEvent = NULL;
    return ret;
}

void QViewPanel::OnMouseEnter(wxMouseEvent &event)
{
	// Get the keyboard focus.
	SetFocus();
}

void QViewPanel::OnActivate(wxActivateEvent& event)
{
	if (event.GetActive() && childView)
		childView->Activate(event.GetActive());
}

void QViewPanel::OnCloseWindow(wxCloseEvent& event)
{
	if(childView)
	{
		bool ans = event.CanVeto()
		           ? childView->Close(false) // false means don't delete associated window
		           : false; // Don't delete.

		if (ans)
		{
			childView->Activate(false);
			delete childView;
			childView = NULL;
		    this->Destroy();
		}
		else if(event.CanVeto())
			event.Veto();
	}
	else
		event.Veto();
}

void QViewPanel::OnPaint(wxPaintEvent &event)
{
	// Create the paint dc.
	wxPaintDC dc(this);

	// Notify the view to draw.
	GetView()->OnDraw(&dc);
}

void QViewPanel::OnSize(wxSizeEvent &event)
{
	if(GetAutoLayout())
		Layout();

	// Notify the view.
	GetView()->OnSize(event.GetSize());
}
