/*
Copyright (C) 1996-1997 GX Media, Inc.
Copyright (C) 2010 Ronie Salgado

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#include "stdafx.h"
#include "QEntSel.h"
#include "QDraw.h"
#include "Game.h"

struct EntSet {
	wxString caption;
	wxString entName;
	wxString gameName;
	wxString palName;
};
static EntSet EntSets[64];
static int numEntSets = 0;

BEGIN_EVENT_TABLE(QEntSel, wxDialog)
	EVT_CHOICE(XRCID("selectGame"), QEntSel::OnGameChoice)
	EVT_BUTTON(wxID_OK, QEntSel::OnOK)
END_EVENT_TABLE()

QEntSel::QEntSel(wxWindow *parent)
{
	wxXmlResource::Get()->LoadDialog(this, parent, wxT("QEntSel"));

	gameNum = 0;

	cfg = new LConfig(wxT("Settings"));
	cfg->RegisterVar(wxT("LastGameNum"), &gameNum, LVAR_INT);
	LoadGames();

	UpdateEntitySet();
}

QEntSel::~QEntSel()
{
	cfg->SaveVars();
	delete cfg;
	cfg = NULL;
}

void QEntSel::UpdateEntitySet()
{
	wxChoice *gameChoice = XRCCTRL(*this, "selectGame", wxChoice);
	wxString game = gameChoice->GetStringSelection();

	wxChoice *entSetChoice = XRCCTRL(*this, "selectEntitySet", wxChoice);
	entSetChoice->Clear();

	for(int i = 0; i < numEntSets; i++)
	{
		if(EntSets[i].gameName != game)
			continue;
		entSetChoice->Append(EntSets[i].caption);
	}

	entSetChoice->SetSelection(0);
}

void QEntSel::LoadEntSets()
{
	// TODO: Clean up this parser.

	LFile file;
	QDraw::OutputText("Loading entity sets...");
	if(!file.Open(wxT("GameSets.txt")))
	{
		QDraw::OutputText("Error.\nGameSets.txt not found.\n");
		LFatal("GameSets.txt not found.");
	}

	numEntSets = 0;

	char *buf, *c, tmp[256];
	while(buf = file.GetNextLine()) {
		c = strchr(buf, 13);
		if(c)
			*c = '\0';

		if(strlen(buf) < 4)
			continue;

		if(buf[0] == ';' || buf[0] == '#' || (buf[0] == '/' && buf[1] == '/'))
			continue;

		strcpy(tmp, buf);
		c = strchr(tmp, ',');
		if(!c)
			continue;
		*c = '\0';
		EntSets[numEntSets].caption = wxString(tmp, wxConvUTF8);

		c++;
		while(*c == ' ' || *c == 9) c++;
		strcpy(tmp, c);
		c = strchr(tmp, ',');
		if(!c)
			continue;
		*c = '\0';
		EntSets[numEntSets].gameName = wxString(tmp, wxConvUTF8);

		c++;
		while(*c == ' ' || *c == 9) c++;
		strcpy(tmp, c);
		c = strchr(tmp, ',');
		if(!c) {
			EntSets[numEntSets].entName = wxString(tmp, wxConvUTF8);
			EntSets[numEntSets].palName = wxT("");
		}
		else {
			*c = '\0';
			EntSets[numEntSets].entName = wxString(tmp, wxConvUTF8);
			c++;
			while(*c == ' ' || *c == 9) c++;
			EntSets[numEntSets].palName = wxString(c, wxConvUTF8);
		}

		numEntSets++;
	}

	// Load the sets embedded in the different games.
	IterLinkList<Game> iter(Game::GetGames());
	Game *game;

	iter.Reset();
	while(!iter.IsDone())
	{
		game = iter.GetNext();

		for(int i = 0; i < game->GetNumGameSets(); i++)
		{
			EntSet &set = EntSets[numEntSets++];
			set.gameName = game->GetName();
			game->GetGameSet(i, set.caption, set.entName, set.palName);
		}
	}

	QDraw::OutputText(" OK\n");
}

void QEntSel::LoadGames()
{
	wxChoice *gameChoice = XRCCTRL(*this, "selectGame", wxChoice);

	IterLinkList<Game> iter(Game::GetGames());
	Game *game;

	iter.Reset();
	while(!iter.IsDone())
	{
		game = iter.GetNext();
		gameChoice->Append(wxString(game->GetName(), wxConvUTF8));
	}

	gameChoice->SetSelection(gameNum);

	if(!numEntSets)
		LoadEntSets();
}

void QEntSel::OnGameChoice(wxCommandEvent& event)
{
	UpdateEntitySet();
}

void QEntSel::OnOK(wxCommandEvent &event)
{
	wxChoice *gameChoice = XRCCTRL(*this, "selectGame", wxChoice);
	wxString gameName = gameChoice->GetStringSelection();

	wxChoice *entSetChoice = XRCCTRL(*this, "selectEntitySet", wxChoice);
	int sel = entSetChoice->GetSelection();

	int i;
	int j = 0;
	for(i = 0; i < numEntSets; i++)
	{
		// Check the game
		if(EntSets[i].gameName != gameName)
			continue;

		// Check the caption.
		if(j++ == sel)
			break;
	}

	this->gameName = EntSets[i].gameName;
	this->caption = EntSets[i].caption;
	this->entName = EntSets[i].entName;
	this->palName = EntSets[i].palName;

	// Continue propagating the event.
	event.Skip();
}
