#include "stdafx.h"
#include "QConf2DView.h"
#include "QConf3DView.h"
#include "QConfDraw.h"
#include "QConfGames.h"
#include "QConfGeneral.h"
#include "QConfSheet.h"

QConfigSheet::QConfigSheet()
{
	page2DView = NULL;
	page3DView = NULL;
	pageDraw = NULL;
	pageGames = NULL;
	pageGeneral = NULL;
}

QConfigSheet::~QConfigSheet()
{
}

bool QConfigSheet::Create(const wxString &title, wxWindow *parent)
{
	if(!wxPropertySheetDialog::Create(parent, wxID_ANY, title))
		return false;

	CreateButtons(wxOK | wxCANCEL);

	wxBookCtrlBase *book = GetBookCtrl();

	// Create the pages.
	pageGeneral = new QConfGeneral(book);
	page2DView = new QConf2DView(book);
	page3DView = new QConf3DView(book);
	pageDraw = new QConfDraw(book);
	pageGames = new QConfGames(book);

	// Add the pages into the book.
	book->AddPage(pageGeneral, _("General"));
	book->AddPage(page2DView, _("2D Views"));
	book->AddPage(page3DView, _("3D Views"));
	book->AddPage(pageDraw, _("Render Library"));
	book->AddPage(pageGames, _("Game Compile"));

	LayoutDialog();
	return true;
}
