#ifndef XMLGAME_H
#define XMLGAME_H

#include "Game.h"

class TextureLoader;
class XmlGame: public Game
{
	XmlGame(int numUtils);
public:
	~XmlGame();

	virtual bool Init(void);
	virtual WireFrameGeom *LoadModel(const wxString &filename);
	virtual bool LoadTexture(Texture *texture, const wxString &filename, int offset);

	// Map parameters.
	virtual int GetDefaultGridSize() const;
	virtual int GetDefaultRotSnapSize() const;
	virtual int GetGridSteps() const;
	virtual int GetGridSizeBase() const;
	virtual float GetNearPlane() const;
	virtual float GetFarPlane() const;

	// Primitives set.
	virtual const wxString &GetPrimitivesSet() const;

	// Game sets.
	virtual int GetNumGameSets();
	virtual void GetGameSet(int index, wxString &name, wxString &entName, wxString &palName);

	// Compile programs.
	virtual int GetNumUtils(void) const;
	virtual const wxString &GetUtilName(int index) const;
	virtual bool GetUtilCmdLine(int utilIndex, const wxString &docName,
								wxString *cmdLine, wxString *initDir,
								OutTextProc pTextProc = NULL) const;

	static XmlGame *LoadGame(const wxString &filename);
	static void LoadGames();

private:
	void BuildConfig();

	const wxString &GetOption(const wxString &name, const wxString &def=wxT("")) const;
	void SetOption(const wxString &name, const wxString &value);
	void AddOption(const wxString &name, wxString *value);

	void ReplaceVars(wxString &string) const;
	inline void ReplaceVars2(wxString &string) const
	{
		ReplaceVars(string);
		ReplaceVars(string);
	}

	// Compiler utilities.
	typedef std::map<wxString, wxString*> Options;
	Options options;

	std::vector<wxString*> dynamicOptions;

	int numUtils;
	std::vector<wxString> utilNames;

	// Game sets.
	struct GameSet
	{
		wxString name;
		wxString entName;
		wxString palName;
	};
	std::vector<GameSet> gameSets;

	// Map parameters.
	int defaultGridSize, defaultRotSnapSize, gridBase;
	int gridSteps;
	float nearPlane, farPlane;

	// Primitives set.
	wxString primitivesSet;

	// Texture loader.
	TextureLoader *textureLoader;
};

#endif //XMLGAME_H
