/*
 Copyright (C) 1996-1997 GX Media, Inc.

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

 */

#ifndef __TEXTURE_H
#define __TEXTURE_H

#include "LCommon.h"
#include "List.h"

#define TEXDB_VER 27
#define TEXDB_ALLOC 500
#define TEXDIR_MAX 128

class Game;
class TexDB;

struct WadHeader
{
	char magic[4];
	unsigned int entries;
	unsigned int offset;
};

struct WadEntry
{
	unsigned int offset;
	unsigned int dsize;
	unsigned int size;
	char type;
	char cmprs;
	short dummy;
	char name[16];
};

struct TexDir
{
	wxString dirName;
	wxString gameName;
	Game *game;
};

struct TexEntry
{
	WadEntry wadEntry;
	wxString name;
	short solid[8];
	short texDir;
	short used;
};

class Texture
{
public:
	Texture(TexEntry *texEntry, Game *game);
	~Texture();

	wxString GetFilename(void);

	bool Cache(void);
	bool CacheSizes();
	const wxString &GetName(void)
	{
		return texEntry->name;
	}
	wxString GetShortName(void);
	wxString GetTexListName(TexDB *texDB);
	short *GetSolidInfo(void);

	bool cached;

	int width, height, bits;
	int realWidth, realHeight;
	float divWidth, divHeight;
	void *surface;

	int mips;
	void *mip[4];

	void *pInfo;
	unsigned int tInfo;

	Game *game;
	TexEntry *texEntry;
};

class TexDB
{
public:
	TexDB(Game *Game);
	~TexDB();

	Texture *AddTexture(const wxString &fullName);
	Texture *FindTexture(const wxString &name, bool iterate = true);

	int AddTexDir(const wxString &name);
	void DelTexDir(TexDir *texDir);
	TexDir *GetTexDir(int dirNum)
	{
		return &texDir[dirNum];
	}
	int GetNumTexDirs(void)
	{
		return texDirs;
	}
	int FindTexDir(const wxString &name);

	void ResetUsed(void);
	void BuildWadFromUsed(const wxString &filename);
	wxString BuildWadListFromUsed(void);

	void SetTryExtract(bool set)
	{
		tryExtract = set;
	}

private:
	Game *game;

	Texture *AddTextureQualified(const wxString &fullName);
	int GetWadEntry(const wxString &dirName, const wxString &texName,
			WadEntry *wadEntry);

	wxString filename;
	std::vector<TexEntry*> texEntries;
	std::vector<Texture*> textures;
	int texDirs;
	TexDir texDir[TEXDIR_MAX];

	bool tryExtract;
};

WX_DEFINE_ARRAY_PTR(Texture *, TexturePointersArray);

class TexList
{
public:
	TexList(const wxString &filename, Game *game);
	~TexList();

	Texture *Add(const wxString &texName);
	void Remove(const wxString &texName);
	void Save(void);

	int GetNumTexs(void)
	{
		return textures.GetCount();
	}
	Texture *GetTexNum(int texNum)
	{
		return textures.Item(texNum);
	}

	wxString filename;
	TexDB *texDB;
	TexturePointersArray textures;
};

#endif
