/*
Copyright (C) 1996-1997 GX Media, Inc.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/


#ifndef __GAME_H
#define __GAME_H

#include "Geometry.h"
#include "Objects.h"
#include "QooleId.h"

class Texture;
class WireFrameGeom;
class TexDB;

typedef void (*OutTextProc)(const char *strText);

class Game : public ElmNode {
public:
	Game(int numUtils);
	virtual ~Game(void);

	const wxString &GetName(void) { return gameName; }
	const wxString &GetGameDir(void) { return gameDir; }
	const wxString &GetBaseDir(void) { return baseDir; }
	const wxString &GetMapExt(void) { return mapExt; }
	const wxString &GetTexDir(void) { return texDir; }
	const wxString &GetTexExt(void) { return texExt; }
	TexDB *GetTexDB(void) { ASSERT(texDB != NULL); return texDB; }

	const wxString &GetPalDef(void) { return palDef; }

	bool IsExportWadSet(void) { return exportWad; }
	bool IsSpecifyWadsSet(void) { return specifyWads; }

	bool UsesWadFile(void) { return texExt.empty(); }
	bool UsesQualifiedTextures() {return qualifiedTextures;}

	Texture *GetDefaultTexture(void);

	virtual bool Init(void) = 0;
	virtual WireFrameGeom *LoadModel(const wxString &filename) = 0;
	virtual bool LoadTexture(Texture *texture, const wxString &filename, int offset) = 0;
	virtual bool LoadTextureSizes(Texture *texture, const wxString &filename, int offset);

	virtual void ExtractTextures(void);

	static LinkList<Game> &GetGames(void) { return games; }

	static Game *Get(void);
	static bool Set(Game *_game, const wxString &palName, float gamma);
	static Game *Find(const wxString &name);
	static void Exit(void);

	const wxString &GetPalName(void) { return palName; }
	LPalette &GetPal(void) { return pal; }

	// Game map parameters.
	virtual int GetDefaultGridSize() const;
	virtual int GetDefaultRotSnapSize() const;
	virtual int GetGridSteps() const;
	virtual int GetGridSizeBase() const;
	virtual float GetNearPlane() const;
	virtual float GetFarPlane() const;

	// Primitives set.
	virtual const wxString &GetPrimitivesSet() const;

	// Additional properties pages.
	virtual unsigned int GetExtraPropPages(void) const;

	// Game sets.
	virtual int GetNumGameSets();
	virtual void GetGameSet(int index, wxString &name, wxString &entName, wxString &palName);

	// Game Map Compile Stuff.
	virtual int GetNumUtils(void) const = 0;
	virtual const wxString &GetUtilName(int index) const = 0;

	virtual void InitCompileParams(bool runUtils[], wxString params[],
								   int &paramIndex) const;
	virtual void SaveCompileParams(bool runUtils[], wxString params[],
								   int &paramIndex);

	virtual const wxString &GetMapExportPath(const wxString &docName,
										 OutTextProc pTextProc = NULL) const;

	virtual bool GetUtilCmdLine(int utilIndex, const wxString &docName,
								wxString *cmdLine, wxString *initDir,
								OutTextProc pTextProc = NULL) const;

	virtual wxString GetLeakFile(const wxString &docName) const { return wxT(""); }
	virtual Object *LoadLeakFile(const wxString &docName) const { return NULL; }

	virtual void CleanUpCompile(const wxString &docName, bool skipBSP = true,
								OutTextProc pTextProc = NULL) const;

	wxString utilsPath[MAXUTILS];

protected:
	LConfig *cfg;
	wxString gameName;
	wxString palName;
	wxString palDef;
	wxString gameDir;
	wxString mapDir;
	wxString baseDir;
	wxString texDir;
	wxString texExt;
	wxString mapExt;

	bool initialized;
	bool exportWad;
	bool specifyWads;
	bool qualifiedTextures;

	int  setPIndex;
	unsigned int runUtilsFlag;
	wxString utilsParams[MAXUTILS];

	wxString defTexture;

	TexDB *texDB;

	LPalette pal;

private:
	static Game *game;
	static LinkList<Game> games;
};

typedef struct {
	float x, y, z;
} vec3_t;

typedef struct {
	vec3_t vert[2];
} edge_t;

typedef struct {
	int v1, v2;
} edgenum_t;

void ExtractTexsFromPak(LPak *pak, const wxString &baseDir);

#endif
