/*
Copyright (C) 2010-2011 Ronie Salgado

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#ifndef QQUAD_FRAME_H
#define QQUAD_FRAME_H

#include "QChildFrame.h"

class QMainFrame;
class QooleDoc;
class QView;
class QQuadFrame: public QChildFrame
{
public:
	QQuadFrame(QMainFrame *parent, QooleDoc *doc);
	~QQuadFrame();

	enum ViewID
	{
		VID_TOP_LEFT = 0,
		VID_TOP_RIGHT,
		VID_BOTTOM_LEFT,
		VID_BOTTOM_RIGHT,
	};

	QView *GetView(ViewID id);

	// Event handlers.
	void OnActivate(wxActivateEvent& event);
	void OnCloseWindow(wxCloseEvent& event);
	DECLARE_EVENT_TABLE();
private:
	QView *views[4];
	QooleDoc *document;
};

#endif //QQUAD_FRAME_H
