/*
Copyright (C) 1996-1997 GX Media, Inc.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#include "stdafx.h"
#include "QDraw.h"
#include "QDrawWX.h"

QDrawWX::QDrawWX(wxWindow *wnd)
	: QDraw(wnd)
{
	wxClientDC wdc(window);

	for(int i = 0; i < numBufs; i++)
	{
		dc[i] = NULL;
		bmp[i] = NULL;
	}
}

QDrawWX::~QDrawWX()
{
	for(int i = 0; i < numBufs; i++)
	{
		delete dc[i];
		delete bmp[i];
	}
}

void
QDrawWX::Size(int cx, int cy) {
	QDraw::Size(cx, cy);

	wxClientDC wdc(window);

	for(int i = 0; i < numBufs; i++)
	{
		delete dc[i];
		delete bmp[i];
		dc[i] = new wxMemoryDC(&wdc);
		bmp[i] = new wxBitmap(cx, cy);
		dc[i]->SelectObject(*bmp[i]);
	}
}

void
QDrawWX::Clear(void) {
	wxBrush bg;
	bg.SetColour(57,57,57);
	dc[useBuf]->SetBackground(bg);
	dc[useBuf]->Clear();
}

void
QDrawWX::Color(int color) {
	dc[useBuf]->SetPen(pen[color]);
}

void
QDrawWX::Begin(void) {
}

void
QDrawWX::Line(int x1, int y1, int x2, int y2) {
	dc[useBuf]->DrawLine(x1, y1, x2, y2);
}

void
QDrawWX::Paint(wxDC *dest)
{
	dest->Blit(0, 0, width, height, dc[useBuf], 0, 0);
}

void QDrawWX::Blit(int x, int y, int width, int height,
			wxBitmap &src, int xsrc, int ysrc, int rop, bool useMask)
{
	wxMemoryDC mem;
	mem.SelectObject(src);
	dc[useBuf]->Blit(x, y, width, height, &mem, xsrc, ysrc, rop, useMask);
	mem.SelectObject(wxNullBitmap);
}

void
QDrawWX::CopyBuf(int bufNum)
{
	dc[useBuf]->Blit(0, 0, width, height, dc[bufNum], 0, 0);
}

void
QDrawWX::RealizePal(void)
{
	for(int i = 0; i < 256; i++)
	{
		pen[i].SetColour(pal[i].red, pal[i].green, pal[i].blue);
		pen[i].SetStyle(wxSOLID);
	}
}

void QDrawWX::ZBufInit(void) { }
void QDrawWX::ZBufClear(void) { }
void QDrawWX::ZBufTriangle(ZPoint zpoint[3]) { }
void QDrawWX::ZBufRender(void) { }
