#include "stdafx.h"
#include "QConfDraw.h"

BEGIN_EVENT_TABLE(QConfDraw, wxPanel)
END_EVENT_TABLE()

QConfDraw::QConfDraw(wxWindow *parent)
	: wxPanel(parent)
{
	// Create the panel layout.
	wxBoxSizer *panelSizer = new wxBoxSizer(wxVERTICAL);

	wxFlexGridSizer *gridSizer = new wxFlexGridSizer(2, 4, 2);
	panelSizer->Add(gridSizer, 0, wxEXPAND|wxALL, 5);

	// Wireframe 2D
	wxStaticText *label = new wxStaticText(this, wxID_ANY, _("2D Views (Wireframe)"));
	wxChoice *wire2D = new wxChoice(this, wxID_ANY);
	gridSizer->Add(label, 0, wxALIGN_CENTER_VERTICAL);
	gridSizer->Add(wire2D);

	// Wireframe 3D
	label = new wxStaticText(this, wxID_ANY, _("3D Views (Wireframe)"));
	wxChoice *wire3D = new wxChoice(this, wxID_ANY);
	gridSizer->Add(label, 0, wxALIGN_CENTER_VERTICAL);
	gridSizer->Add(wire3D);

	// Solid 3D
	label = new wxStaticText(this, wxID_ANY, _("3D Views (Solid)"));
	wxChoice *solid3D = new wxChoice(this, wxID_ANY);
	gridSizer->Add(label, 0, wxALIGN_CENTER_VERTICAL);
	gridSizer->Add(solid3D);

	// Textured 3D
	label = new wxStaticText(this, wxID_ANY, _("3D Views (Textured)"));
	wxChoice *textured3D = new wxChoice(this, wxID_ANY);
	gridSizer->Add(label, 0, wxALIGN_CENTER_VERTICAL);
	gridSizer->Add(textured3D);

	// Set the sizer.
	SetSizer(panelSizer);
	panelSizer->Fit(this);
}

QConfDraw::~QConfDraw()
{
}
