//.pcx -> .wal converter by Trey Harrison
//http://crack.com/games/golgotha
//trey@crack.com


#include <stdio.h>
#include <conio.h>
#include <string.h>
#include <stdlib.h>
#include <memory.h>
#include "file_list.h"

unsigned char pcx_pal[768];
extern unsigned char quake2_pal[]; //q2pal.c
int dont_adapt=0;
int argc;
char **argv;

void remove_extention(char *string);
void write_mip(FILE *f,unsigned char *base_mip, int base_width, int base_height, int miplevel);
unsigned char average_pixels(unsigned char *src, int miplevel,int bytesperline);

int main(int arg_count, char **arg_strings)
{
  argc = arg_count;
  argv = arg_strings;

  FILE *f;
  int   i,j;

  char  walname[32];
  int   mip1_offs,mip2_offs,mip3_offs,mip4_offs;  
  int   width,height;
  short w,h;
  int   mipsize;
  int   fname_num=1;

  unsigned char *mip=0;
  unsigned char cur_byte;
  int run_len;
  
  if (argc<2)
  {
    printf("Must specify the .pcx file\n");
    exit(-1);
  }    
  
  file_name_class *file_names = FileList(argv[fname_num]);
  
  while (file_names)
  {
    if (argc==3)
    {
      if (!stricmp(argv[2],"-noadapt"))
      {
        dont_adapt=1;
        fname_num=1;
      }
      
      if (!stricmp(argv[1],"-noadapt"))
      {
        dont_adapt=1;
        fname_num=2;
      }
    }
    
    f = fopen(file_names->name,"rb");
    if (!f)
    {
      printf("Invalid input .pcx file: %s\n",file_names->name);
      exit(-1);
    }

    remove_extention(file_names->name);

	  fseek(f,8,SEEK_SET);        
	  fread(&w,sizeof(short),1,f);
	  fread(&h,sizeof(short),1,f);
    width  = w+1;
    height = h+1;
    
    mipsize = width*height;
	
    mip = new unsigned char[mipsize];
	
  	fseek(f,128,SEEK_SET);
  	j = 0;
    //decoding loop type thing
	
  	while(j < mipsize)
    {
		  cur_byte = fgetc(f);
		  if((cur_byte & 0xC0) == 0xC0)
      {
  			run_len = cur_byte & 0x3F;
			  cur_byte = fgetc(f);
			  for( ;(run_len>0) && (j<mipsize); run_len--, j++)
        {
				  mip[j] = cur_byte;
			  }
		  }
      else
      {
  			mip[j] = cur_byte;
			  j++;
		  }
	  }
	  
	  fseek(f,-768,SEEK_END);
    fread(pcx_pal,768,1,f);

    fclose(f);

    if (!dont_adapt)
    {
      //we're adapting. dont worry, however, if the palettes are the same
      if (!memcmp(pcx_pal,quake2_pal,768))
        dont_adapt = 1;
    }

    strcpy(walname,file_names->name);
    strcat(walname,".wal");

    f = fopen(walname,"wb");
    if (!f)
    {
      printf("Invalid output .wal name: %s\n",walname);
      exit(-1);
    }

    mip1_offs = 100;
    mip2_offs = mip1_offs + mipsize;
    mip3_offs = mip2_offs + mipsize/4;
    mip4_offs = mip3_offs + mipsize/16;

    remove_extention(walname);
    fwrite(walname,32,1,f);

    fwrite(&width,1,sizeof(int),f);
    fwrite(&height,1,sizeof(int),f);

    fwrite(&mip1_offs,1,sizeof(int),f);
    fwrite(&mip2_offs,1,sizeof(int),f);
    fwrite(&mip3_offs,1,sizeof(int),f);
    fwrite(&mip4_offs,1,sizeof(int),f);

    //44 bytes of 0's
    for (i=0;i<44;i++)
      fputc(0,f);

    write_mip(f,mip,width,height,0);
    write_mip(f,mip,width,height,1);
    write_mip(f,mip,width,height,2);
    write_mip(f,mip,width,height,3);  
  
    printf("%s.wal completed.\n",walname);
    fclose(f);

    //destruct this list as we go through it
    file_name_class *next = file_names->next;
    delete file_names;
    file_names = next;
  }

  return 0;
}

#define ABS(x) (x)>(0)?(x):(-(x))

__inline unsigned char remap_pixel(int ir, int ig, int ib)
{
  int i;
  int diff,min_diff=99999;
  unsigned char match=0;    

  unsigned char *pal;

  if (!dont_adapt)
    pal = quake2_pal;
  else
    pal = pcx_pal;

  for (i=0;i<256;i++,pal+=3)
  {
    diff = 0;
    
    diff += ABS(pal[0]-ir);
    diff += ABS(pal[1]-ig);
    diff += ABS(pal[2]-ib);
    
    if (diff<min_diff)
    {
      min_diff = diff;
      match = i;
    }
  }
  
  return match;
}

void write_mip(FILE *f,unsigned char *base_mip,int base_width, int base_height, int miplevel)
{
  int mipsize = base_width/(1<<miplevel) * base_height/(1<<miplevel);
  int i,j;
  int w,h;
  
  unsigned char *new_mip=0;
  unsigned char *dst=0;

  int s,t,mipstep;

  printf("Writing mip %d...\n",miplevel+1);

  //simpler case
  if (miplevel==0)
  {
    //simple case, no palette adaptation, 1x1 pixel ratio
    if (dont_adapt)
    {      
      fwrite(base_mip,mipsize,1,f);      
      return;    
    }
    else
    {
      new_mip = new unsigned char [mipsize];
      dst     = new_mip;

      for (j=0; j<base_height; j++) 
      for (i=0; i<base_width;  i++,base_mip++)
      {    
        *dst = remap_pixel(pcx_pal[(*base_mip)*3+0],
                           pcx_pal[(*base_mip)*3+1],
                           pcx_pal[(*base_mip)*3+2]);                
        dst++;
      }
      
      fwrite(new_mip,mipsize,1,f);
      delete [mipsize] new_mip;
      return;
    }
  }
  
  w = base_width  >> miplevel;
  h = base_height >> miplevel;
  
  mipstep = 1<<miplevel;

  new_mip = new unsigned char [mipsize];
  dst     = new_mip;

  for (j=0,t=0; j<h; j++,t += mipstep) 
  for (i=0,s=0; i<w; i++,s += mipstep)
  {
    *dst = average_pixels(&base_mip[t*base_width+s],mipstep,base_width);
    dst++;
  }
  
  fwrite(new_mip,mipsize,1,f);
  delete [mipsize] new_mip;
}

unsigned char average_pixels(unsigned char *src, int miplevel, int bytesperline)
{
  unsigned char ir,ig,ib;
  double r=0,g=0,b=0;  
  int    i,j;
  int    total_pixels=0;  
  
  double oot;
  
  unsigned char *texel=src;
  int texeloffs;
  
  for (j=0;j<miplevel;j++,texel += (bytesperline-miplevel))
  for (i=0;i<miplevel;i++)
  {    
    texeloffs = (*texel) * 3;
  
    r += (double)pcx_pal[texeloffs+0];
    g += (double)pcx_pal[texeloffs+1];
    b += (double)pcx_pal[texeloffs+2];
    
    total_pixels++;
    texel++;
  }
  
  oot = 1.0 / (double)(total_pixels);
  r *= oot;
  g *= oot;
  b *= oot;
  
  ir = (unsigned char)r;
  ig = (unsigned char)g;
  ib = (unsigned char)b;

  return remap_pixel(ir,ig,ib);
}

void remove_extention(char *name)
{
  char *last_period=0;

  while (*name)
  {
    if (*name=='.')
      last_period = name;
    name++;
  }
  
  if (last_period)
    *last_period = 0;
}