
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <ctype.h>
#include "curs.h"

/*
 *  General-purpose cursor control routines for QBSP, VIS, and LIGHT.
 *  These are used so that cursor control can be done compatibly
 *  with other architectures (namely UNIX).  This version implements
 *  cursor control with CONIO.H (available with Turbo C and with DJGPP).
 */

#include <conio.h>

int backtable[8] = { 0, 4, 2, 6, 1, 5, 3, 7 };
int foretable[8] = { 0, 12, 10, 14, 9, 13, 11, 15 };

struct vidbuf {
	int x, y, width, height;
	void *memory;
};       

int ScrnWidth, ScrnHeight;

void InitText(void)
{
	textmode(3);			/* Reset to normal text mode */
	_setcursortype(_NOCURSOR);	/* Hide the cursor */
	clrscr();			/* Clear the screen */
	gotoxy(1, 1);			/* Home the cursor */

	ScrnWidth = 80;
	ScrnHeight = 24;		/* If it were 25, it would scroll, damn it. */
}

void MoveCurs(int x, int y)
{
	gotoxy(x+1, y+1);	/* X and Y are zero-based */
}

void GetCurs(int *x, int *y)
{
	*x = wherex() - 1;	/* X and Y are zero-based */
	*y = wherey() - 1;
}

void SetForeColor(int color)
{
	if (color > 7 || color < 0) color = 7;
	textcolor(foretable[color]);
}

void SetBackColor(int color)
{
	if (color > 7 || color < 0) color = 7;
	textbackground(backtable[color]);
}

void CPrintf(char *format, ...)
{
	register char c;
	register char *ptr, *src;
        int x, y;
        char text[1024];
	char text2[1024];
        va_list v;

	va_start(v, format);
	vsprintf(text, format, v);

	GetCurs(&x, &y);

	for (ptr = text2, src = text; *src != '\0'; src++) {
		c = *src;

		if (c == '$') {
			switch (*++src) {
			case '$':
				*ptr++ = '$';
                                break;
                        case 'a':
				*ptr = '\0';
				cputs(ptr = text2);
                                RingBell();
                                break;
                        case 'n':
				*ptr = '\0';
				cputs(ptr = text2);
                                MoveCurs(x, ++y);
                                break;
			case 'f':
				*ptr = '\0';
				cputs(ptr = text2);
				SetForeColor(toupper(*++src)-'0');
				break;
			case 'b':
				*ptr = '\0';
				cputs(ptr = text2);
				SetBackColor(toupper(*++src)-'0');
				break;
			case 'c':
				*ptr = '\0';
				cputs(ptr = text2);
				SetForeColor(toupper(*++src)-'0');
				SetBackColor(toupper(*++src)-'0');
				break;
                        }
                }
		else if (c >= 32 && c <= 126)
			*ptr++ = c;
	}
	*ptr = '\0';
	cputs(ptr = text2);
}

void RingBell(void)
{
	putch('\a');
}

void FillBox(int x, int y, int width, int height, char c)
{
	register int i;
	char boxdata[256];

	for (i = 0; i < width; i++)
		boxdata[i] = c;
	boxdata[i] = '\0';

	for (i = 0; i < height; i++) {
		gotoxy(x+1, i+1+y);
		cputs(boxdata);
        }
}

void DrawBox(int x, int y, int width, int height)
{
	register int i;

        gotoxy(x+1, y+1);
	cputs("");
	for (i = 0; i < width - 2; i++)
		cputs("");
	cputs("");

	for (i = 1; i < height-1; i++) {
		gotoxy(x+1, i+1+y);
		cputs("");
		gotoxy(x+width, i+1+y);
		cputs("");
        }

	gotoxy(x+1, y+height);
	cputs("");
	for (i = 0; i < width - 2; i++)
		cputs("");
	cputs("");
}

void DrawFilledBox(int x, int y, int width, int height)
{
	register int i;
        char boxdata[256];

	for (i = 0; i < width; i++)
		boxdata[i] = ' ';
	boxdata[0] = '';
	boxdata[i-1] = '';
        boxdata[i] = '\0';

        gotoxy(x+1, y+1);
	cputs("");
	for (i = 0; i < width - 2; i++)
		cputs("");
	cputs("");

	for (i = 1; i < height-1; i++) {
		gotoxy(x+1, i+1+y);
		cputs(boxdata);
        }

	gotoxy(x+1, y+height);
	cputs("");
	for (i = 0; i < width - 2; i++)
		cputs("");
	cputs("");
}

void DrawHLine(int x, int y, int length)
{
	register int i;

	gotoxy(x+1, y+1);
	for (i = 0; i < length; i++)
		cputs("");
}

void DrawVLine(int x, int y, int length)
{
	register int i;

	for (i = 0; i < length; i++) {
		gotoxy(x+1, i+1+y);
		cputs("");
	}
}

void CopyText(int x1, int y1, int width, int height, int x2, int y2)
{
	void *mem = malloc(width*height*2);

	gettext(x1-1, y1-1, x1+width, y1+height, mem);
	puttext(x2-1, y2-1, x2+width, y2+height, mem);
}

int IsKey(void)
{
	return(kbhit());
}

int WaitKey(void)
{
	return(getch());
}

int GetKey(void)
{
	if (kbhit()) return(getch());
	else return(0);
}

void HideCurs(void)
{
	_setcursortype(_NOCURSOR);
}

void ShowCurs(void)
{
	_setcursortype(_NORMALCURSOR);
}

