#ifndef u32
  #define u32 unsigned int
#endif
#ifndef s32
  #define s32 signed int
#endif
#ifndef u8
  #define u8 unsigned char
#endif
#ifndef f32
  #define f32 float
#endif

#define RAD3DSURFACE32    0
#define RAD3DSURFACE32A   1
#define RAD3DSURFACE555   2
#define RAD3DSURFACE565   3
#define RAD3DSURFACE5551  4
#define RAD3DSURFACE4444  5

#ifdef _XBOX
  #define RAD3DSURFACECOUNT RAD3DSURFACE4444+1
#else
  #define RAD3DSURFACE32R   6
  #define RAD3DSURFACE32RA  7
  #define RAD3DSURFACE24    8
  #define RAD3DSURFACE24R   9
  #define RAD3DSURFACECOUNT RAD3DSURFACE24R+1
#endif

#ifdef __cplusplus
  #define RADCFUNC extern "C"
#else
  #define RADCFUNC
#endif


#ifdef _XBOX

#define HRAD3D LPDIRECT3DDEVICE8

#else

//
// Define the handle types.
//

struct RAD3D;
typedef struct RAD3D* HRAD3D;

//
// Functions to open a RAD 3D handle (to OpenGL or Direct3D).
//

RADCFUNC HRAD3D Open_RAD_3D( HWND window );

RADCFUNC void Close_RAD_3D( HRAD3D rad_3D );

RADCFUNC void Resize_RAD_3D( HRAD3D rad_3d,
                             u32 width,
                             u32 height );

RADCFUNC char* Describe_RAD_3D( void );

#endif

RADCFUNC void Start_RAD_3D_frame( HRAD3D rad_3D );

RADCFUNC void End_RAD_3D_frame( HRAD3D rad_3D );

//
// Define the handle types.
//

struct RAD3DIMAGE;
typedef struct RAD3DIMAGE* HRAD3DIMAGE;

//
// Functions to open a 3D image handle (GL or D3D texture array).
//

RADCFUNC HRAD3DIMAGE Open_RAD_3D_image( HRAD3D rad_3d,
                                        u32 width,
                                        u32 height,
#ifdef _XBOX
                                        u32 rad3d_surface_format
#else
                                        s32 alpha_pixels,
                                        u32 maximum_texture_size
#endif
                                        );

RADCFUNC void Close_RAD_3D_image( HRAD3DIMAGE rad_image );

RADCFUNC s32 Lock_RAD_3D_image( HRAD3DIMAGE rad_image,
                                void* out_pixel_buffer,
                                u32* out_buffer_pitch,
                                u32* out_surface_type );

RADCFUNC void Unlock_RAD_3D_image( HRAD3DIMAGE rad_image );

RADCFUNC void Blit_RAD_3D_image( HRAD3DIMAGE rad_image,
                                 f32 x_offset,
                                 f32 y_offset,
                                 f32 x_scale,
                                 f32 y_scale,
                                 f32 alpha_level );

RADCFUNC void Draw_lines_RAD_3D_image( HRAD3DIMAGE rad_image,
                                       f32 x_offset,
                                       f32 y_offset,
                                       f32 x_scale,
                                       f32 y_scale );

