// FUTILS.H -- File utils.
// Copyrigth  1999 Joe Riedel, Nick Randal.
// Author: Joe Riedel.
#ifndef FUTILS_H
#define FUTILS_H

#include <io.h>

unsigned char* BloadFile(CString sFilename, int& nNumBytes);

// Filename searching.

class CFileSearch
{
private:

	CFileSearch* m_pSubSearch;
	CString m_sDir, m_sFileExt;
	bool m_bFirstFind;
	bool m_bRecursive;
	struct _finddata_t m_fileinfo;
	int	m_nHandle;

	bool SetupRecursiveSearch();
	bool GetNextRecursiveFile(CString& sFilename);
	bool KillRecursiveSearch();

public:

	bool BeginFileSearch(CString sDir, CString sFileExt, bool bRecursive=false);
	void EndFileSearch();
	bool GetNextFile(CString& sFilename);

};

bool ReadNString(CFile& hFile, CString& sString, int nLen);
bool WriteNString(CFile& hFile, CString sString, int nLen);
bool ReadString(CFile& hFile, CString& sString);
bool WriteString(CFile& hFile, CString sString);
bool ReadLongString(CFile& hFile, CString& sString);
bool ReadInt(CFile& hFile, int& nInt);
bool WriteInt(CFile& hFile, int nInt);
bool ReadBool(CFile& hFile, bool& bVal);
bool WriteBool(CFile& hFile, bool bVal);
bool ReadFloat(CFile& hFile, float& fFloat);
bool WriteFloat(CFile& hFile, float fFloat);

#endif