# TrenchBroom

[![TrenchBroom Icon](app/resources/graphics/images/AppIcon.png)](https://www.youtube.com/watch?v=shcAvnYp9ow)

TrenchBroom is a modern cross-platform level editor for Quake-engine based games.

- Trailer:   https://www.youtube.com/watch?v=shcAvnYp9ow
- Website:   https://github.com/TrenchBroom/TrenchBroom
- Discord:   https://discord.gg/WGf9uve
- Twitter:   https://twitter.com/tb_leveleditor
- Video Tutorial Series:  https://www.youtube.com/playlist?list=PLgDKRPte5Y0AZ_K_PZbWbgBAEt5xf74aE
- Manual:    https://trenchbroom.github.io/manual/latest

## Features
* **General**
	- Full support for editing in 3D and in up to three 2D views
	- High performance renderer with support for huge maps
	- Unlimited Undo and Redo
	- Macro-like command repetition
	- Issue browser with automatic quick fixes
	- Point file support
	- Automatic backups
	- .obj file export
	- Free and cross platform
* **Brush Editing**
	- Robust vertex editing with edge and face splitting and manipulating multiple vertices together
	- Clipping tool with two and three points
	- Scaling and shearing tools
	- CSG operations: merge, subtract, intersect
	- UV view for easy texture manipulations
	- Precise texture lock for all brush editing operations
	- Multiple texture collections
* **Entity Editing**
	- Entity browser with drag and drop support
	- Support for FGD and DEF files for entity definitions
	- Mod support
	- Entity link visualization
	- Displays 3D models in the editor
	- Smart entity property editors
* **Supported Games**
	- Quake (Standard and Valve 220 file formats)
	- Quake 2
	- Quake 3 (partial, no patches or brush primitives yet)
	- Hexen 2
	- Daikatana
	- Generic (for custom engines)
	- More games can be supported with custom game configurations


## Releases
- Binary builds are available from [releases](https://github.com/kduske/TrenchBroom/releases).

## Compiling
- Read [Build.md](Build.md) for instructions

# Contributing
- Bug reports and feature suggestions are welcome. Please submit them at https://github.com/TrenchBroom/TrenchBroom/issues
- If you wish to contribute code or improve the documentation, please get in touch with me at kristian.duske@gmail.com.
- All help is appreciated!

# Credits
- [Qt](https://www.qt.io/)
- [FreeType](https://www.freetype.org/)
- [FreeImage](https://freeimage.sourceforge.io/)
- [GLEW](https://github.com/nigels-com/glew)
- [TinyXML](http://www.grinninglizard.com/tinyxml/)
- miniz
- [Assimp](https://www.assimp.org/)
- [Catch2](https://github.com/catchorg/Catch2)
- [CMake](https://cmake.org/)
- [vcpkg](https://www.vcpkg.io/)
- [Pandoc](https://www.pandoc.org/)
- Quake icons by [Th3 ProphetMan](https://www.deviantart.com/th3-prophetman)
- Hexen 2 icon by [thedoctor45](https://www.deviantart.com/thedoctor45)
- [Source Sans Pro](https://fonts.google.com/specimen/Source+Sans+Pro) font

## Changes
See [releases](https://github.com/TrenchBroom/TrenchBroom/releases) for latest changes.
