MACRO(CHECK_REPOSITORY_CLEAN GIT SOURCE_DIR)
    EXECUTE_PROCESS(COMMAND ${GIT} status --short WORKING_DIRECTORY ${SOURCE_DIR} OUTPUT_VARIABLE GIT_STATUS_RESULT OUTPUT_STRIP_TRAILING_WHITESPACE)
    STRING(LENGTH "${GIT_STATUS_RESULT}" GIT_STATUS_LENGTH)
    IF(GIT_STATUS_LENGTH GREATER 0)
        MESSAGE(STATUS "Warning: Repository status is dirty")
    ENDIF()
ENDMACRO(CHECK_REPOSITORY_CLEAN)

MESSAGE(STATUS "${SOURCE_DIR}")

FIND_PACKAGE(Git)
CHECK_REPOSITORY_CLEAN("${GIT_EXECUTABLE}" "${SOURCE_DIR}")

