
Info = {
   "plug-in":       "Side Tag & Glue",
   "desc":          "Basic Side tagging and gluing to tagged side",
   "date":          "1999",
   "author":        "tiglari",
   "author e-mail": "tiglari@hexenworld.net",
   "quark":         "Version 6" }


import quarkx
import quarkpy.mapmenus
import quarkpy.mapentities
import quarkpy.qmenu
import quarkpy.mapeditor
import quarkpy.mapcommands
from quarkpy.maputils import *

class Tagging:
    tagged = None

def gettagged(o):
    try:
        return o.tagging.tagged
    except (AttributeError): return None

def tagSideClick (m):
    editor = mapeditor()
    #
    #  do we have an editor? the function mapeditor() returns the editor
    #   from which the command was invoked.  If we don't, bail.
    #
    if editor is None: return
    #
    #  attach a new tagging object to it (to keep track of what side
    #  is tagged).  `Tagging()' is the `default constructor', automatically
    #  provided to make a new instance of the class, if no explicit
    #  constructor has been defined
    #
    editor.tagging = Tagging()
    #
    # get the editor's selection-list and stick it in a local variable
    #
    tagged = editor.layout.explorer.sellist
    #
    # now check that what's selected is exactly one side
    #
    if (len(tagged) < 1):
        quarkx.msgbox("No selection", MT_ERROR, MB_OK)
    elif (len(tagged) > 1):
        quarkx.msgbox("Only one selection allowed", MT_ERROR, MB_OK) 
    elif (tagged[0].type!= ":f"):
        quarkx.msgbox("The selected object is not a face", MT_ERROR, MB_OK) 
    #
    # and at last we're ready to rock and roll!
    #
    else:
        #
        #  This actually stashes our tagged side (the first & only
        #  element of a one-element list) in the tagging object
        #  that we've attached to the editor.
        #
        editor.tagging.tagged = tagged[0]


def glueSideClick (m):
    editor = mapeditor()
    if editor is None: return
    tagged = gettagged(editor)
    if tagged is None:
        quarkx.msgbox("Something must be tagged",MT_WARNING,MB_OK)
    #
    # get the selection (which will be a list)
    #
    sides = editor.layout.explorer.sellist
    #
    # check that it meets conditions (this could be done more slickly)
    #
    if len(sides) < 1:
        quarkx.msgbox("Something must be selected for glueing", MT_WARNING, MB_OK)
        return
    if len(sides) > 1:
        quarkx.msgbox("Only one thing may be selected for glueing", MT_WARNING, MB_OK)
        return
    if sides[0].type != ":f":
        quarkx.msgbox("The selection must be a face", MT_WARNING, MB_OK)
    #
    # Now derive the new side
    #
    side = sides[0]
    newside = glueToTagged(side, tagged)
    # First create an `undo' object with the quarkx.action()
    #  function.  This will keep track of the actions performed.
    #
    undo = quarkx.action()
    #
    # Now substitute the new side for the old one (in the undo object)
    #
    undo.exchange(side, newside)
    #
    # and perform the action for real in the map
    #
    undo.ok(editor.Root, "glue to tagged")

def glueToTagged(side, tagged):
    #
    # Make a copy of the original (so that texture etc. info is preserved)
    #
    new = side.copy()
    #
    # .distortion rotates the face into a new position; we have
    #  to make sure that the normal is going to point outward from
    #  its parent poly.
    #
    if new.normal*tagged.normal < 0:
        new.distortion(-tagged.normal, new.origin)
    else: new.distortion(tagged.normal, new.origin)
    #
    #  Now shift our new side into position:
    #
    new.translate(tagged.origin-new.origin)
    return new



quarkpy.mapcommands.items.append(quarkpy.qmenu.item("&Tag side", tagSideClick))
quarkpy.mapcommands.items.append(quarkpy.qmenu.item("&Glue to tagged", glueSideClick))

