// PlugInTest.cpp : Defines the initialization routines for the DLL.
//

#include "stdafx.h"
#include "PlugInTest.h"
#include "resource.h"		// main symbols
#include "..\qerplugin.h"

#include "mathlib.h"
#include <math.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

//
//	Note!
//
//		If this DLL is dynamically linked against the MFC
//		DLLs, any functions exported from this DLL which
//		call into MFC must have the AFX_MANAGE_STATE macro
//		added at the very beginning of the function.
//
//		For example:
//
//		extern "C" BOOL PASCAL EXPORT ExportedFunction()
//		{
//			AFX_MANAGE_STATE(AfxGetStaticModuleState());
//			// normal function body here
//		}
//
//		It is very important that this macro appear in each
//		function, prior to any calls into MFC.  This means that
//		it must appear as the first statement within the 
//		function, even before any object variable declarations
//		as their constructors may generate calls into the MFC
//		DLL.
//
//		Please see MFC Technical Notes 33 and 58 for additional
//		details.
//

/////////////////////////////////////////////////////////////////////////////
// CPlugInTestApp

BEGIN_MESSAGE_MAP(CPlugInTestApp, CWinApp)
	//{{AFX_MSG_MAP(CPlugInTestApp)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPlugInTestApp construction

_QERFuncTable_1 g_FuncTable;


CPlugInTestApp::CPlugInTestApp()
{
	// TODO: add construction code here,
	// Place all significant initialization in InitInstance
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CPlugInTestApp object

CPlugInTestApp theApp;

char	*TranslateString (char *buf)
{
	static	char	buf2[32768];
	int		i, l;
	char	*out;

	l = strlen(buf);
	out = buf2;
	for (i=0 ; i<l ; i++)
	{
		if (buf[i] == '\n')
		{
			*out++ = '\r';
			*out++ = '\n';
		}
		else
			*out++ = buf[i];
	}
	*out++ = 0;

	return buf2;
}

void Sys_Printf (char *text, ...)
{
	va_list argptr;
	char	buf[32768];
	char	*out;

	va_start (argptr,text);
	vsprintf (buf, text,argptr);
	va_end (argptr);

	out = TranslateString (buf);

	g_FuncTable.m_pfnSysMsg ( out );
}


// plugin stuff
//
const char *PLUGIN_NAME = "Rogue Brush Repair";
// separate commands with ;
const char *PLUGIN_COMMANDS = "About...;-;Find Mixed Contents;Count Mixed Contents;Remove Duplicate Planes;Purge Evil Polys";

void _QERDeleteSelection()
{
  if (g_FuncTable.m_pfnDeleteSelection)
    (*g_FuncTable.m_pfnDeleteSelection)();
}

void _QERCreateBrush(vec3_t vMin, vec3_t vMax)
{
  if (g_FuncTable.m_pfnCreateBrush)
    (*g_FuncTable.m_pfnCreateBrush)(vMin, vMax);
}

LPVOID _QERCreateBrushHandle()
{
  if (g_FuncTable.m_pfnCreateBrushHandle)
    return (*g_FuncTable.m_pfnCreateBrushHandle)();
  else
    return NULL;
}

void _QERDeleteBrushHandle(LPVOID vp)
{
  if (g_FuncTable.m_pfnDeleteBrushHandle)
    (*g_FuncTable.m_pfnDeleteBrushHandle)(vp);
}

void _QERCommitBrushHandleToMap(LPVOID vp)
{
  if (g_FuncTable.m_pfnCommitBrushHandle)
    (*g_FuncTable.m_pfnCommitBrushHandle)(vp);
}

void _QERAddFace(LPVOID vp, vec3_t v1, vec3_t v2, vec3_t v3)
{
  if (g_FuncTable.m_pfnAddFace)
    (*g_FuncTable.m_pfnAddFace)(vp, v1, v2, v3);
}

LPVOID WINAPI QERPlug_GetFuncTable()
{
  return &g_FuncTable;
}

LPCSTR WINAPI QERPlug_Init(HMODULE hApp, HWND hwndMain)
{
   AFX_MANAGE_STATE(AfxGetStaticModuleState());
   memset(&g_FuncTable, 0, sizeof(_QERFuncTable_1));
   g_FuncTable.m_fVersion = 1.00;
   g_FuncTable.m_nSize = sizeof(_QERFuncTable_1);
   
   return "Rogue Brush Repair v1.0";
}

LPCSTR WINAPI QERPlug_GetName()
{
  return PLUGIN_NAME;
}

LPCSTR WINAPI QERPlug_GetCommandList()
{
  return PLUGIN_COMMANDS;
}

bool HasVolume(vec3_t vMin, vec3_t vMax)
{
  for (int i = 0; i < 3; i++)
  {
    if (vMax[i] - vMin[i] > 0)
      return true;
  }
  return false;
}

//FIXME: remove the above wrapper calls to the table funcs as they 
// were mainly for old style.. once this is valid, can safely direct
// call through table without sanity checks
bool TableIsValid()
{
  return ( (g_FuncTable.m_pfnActiveBrushCount != NULL) &&
           (g_FuncTable.m_pfnAddFace != NULL) &&
           (g_FuncTable.m_pfnAddFaceData != NULL) &&
           (g_FuncTable.m_pfnAllocateActiveBrushHandles != NULL) &&
           (g_FuncTable.m_pfnAllocateSelectedBrushHandles != NULL) &&
           (g_FuncTable.m_pfnCommitBrushHandle != NULL) &&
           (g_FuncTable.m_pfnCreateBrush != NULL) &&
           (g_FuncTable.m_pfnCreateBrushHandle != NULL) &&
           (g_FuncTable.m_pfnDeleteBrushHandle != NULL) &&
           (g_FuncTable.m_pfnDeleteSelection != NULL) &&
           (g_FuncTable.m_pfnGetActiveBrushHandle != NULL) &&
           (g_FuncTable.m_pfnGetCurrentTexture != NULL) &&
           (g_FuncTable.m_pfnGetFaceCount != NULL) &&
           (g_FuncTable.m_pfnGetFaceData != NULL) &&
           (g_FuncTable.m_pfnGetPoints != NULL) &&
           (g_FuncTable.m_pfnGetSelectedBrushHandle != NULL) &&
           (g_FuncTable.m_pfnGetTexture != NULL) &&
           (g_FuncTable.m_pfnHideInfoMsg != NULL) &&
           (g_FuncTable.m_pfnInfoMsg != NULL) &&
           (g_FuncTable.m_pfnReleaseActiveBrushHandles != NULL) &&
           (g_FuncTable.m_pfnReleaseSelectedBrushHandles != NULL) &&
           (g_FuncTable.m_pfnSelectedBrushCount != NULL) &&
           (g_FuncTable.m_pfnSetCurrentTexture != NULL) &&
           (g_FuncTable.m_pfnSetFaceData != NULL) &&
           (g_FuncTable.m_pfnSysMsg != NULL) &&
           (g_FuncTable.m_pfnTextureBrush != NULL) &&
           (g_FuncTable.m_pfnTextureCount != NULL) &&
		   (g_FuncTable.m_pfnDeleteFace != NULL) &&
		   (g_FuncTable.m_pfnBuildBrush != NULL) );
}

/*
================
PlanesEqual
================
*/
#define	NORMAL_EPSILON	0.00001
#define	DIST_EPSILON	0.01
qboolean PlanesEqual (plane_t *p1, plane_t *p2)
{
	if (fabs(p1->normal[0] - p2->normal[0]) < NORMAL_EPSILON
			&& fabs(p1->normal[1] - p2->normal[1]) < NORMAL_EPSILON
			&& fabs(p1->normal[2] - p2->normal[2]) < NORMAL_EPSILON
			&& fabs(p1->dist - p2->dist) < DIST_EPSILON )
		return true;

	return false;
}


void MakeFacePlane (_QERFaceData *f, plane_t *plane)
{
	int		j;
	vec3_t	t1, t2, t3;
	
// convert to a vector / dist plane
	for (j=0 ; j<3 ; j++)
	{
//		t1[j] = f->planepts[0][j] - f->planepts[1][j];
//		t2[j] = f->planepts[2][j] - f->planepts[1][j];
//		t3[j] = f->planepts[1][j];
		t1[j] = f->m_v1[j] - f->m_v2[j];
		t2[j] = f->m_v3[j] - f->m_v2[j];
		t3[j] = f->m_v2[j];
	}
	
	CrossProduct(t1,t2, plane->normal);
	if (VectorCompare (plane->normal, vec3_origin))
		printf ("WARNING: brush plane with no normal\n");
	VectorNormalize (plane->normal);
	plane->dist = DotProduct (t3, plane->normal);
}

/*
================
FacesEqual
================
*/
qboolean FacesEqual (_QERFaceData *faceA, _QERFaceData *faceB)
{
	plane_t	planeA, planeB;

	if(!faceA || !faceB)
		return false;

	MakeFacePlane (faceA, &planeA);
	MakeFacePlane (faceB, &planeB);
	if(PlanesEqual(&planeA, &planeB))
		return true;

	return false;
}

/*
================
PlanesEqual
================
*/
qboolean PointsEqual (vec3_t p1, vec3_t p2)
{
	if(p1[0] == p2[0] && p1[1] == p2[1] && p1[2]==p2[2])
		return true;

	return false;
}

/*
================
PurgeEvilPolys
================
*/
void PurgeEvilPolys (void)
{
	brush_t			*brush;
	_QERFaceData	*faceA;
	qboolean		killBrush;
	int				brushesRemoved;
	int				brushNum;
	int				brushCount;
	int				faceNum, faceCount;
	char			message[256];

	if(g_FuncTable.m_pfnActiveBrushCount() < 1)
		return; 

	g_FuncTable.m_pfnAllocateActiveBrushHandles();
	brushCount = g_FuncTable.m_pfnActiveBrushCount();

	brushesRemoved = 0;
	brushNum = 0;
	for (brushNum = 0; brushNum < brushCount; brushNum++)
	{
		brush = (brush_t *)g_FuncTable.m_pfnGetActiveBrushHandle(brushNum);
		killBrush = 0;
		faceCount = g_FuncTable.m_pfnGetFaceCount(brush);
		for(faceNum = 0; faceNum < faceCount; faceNum++)
		{
			faceA = g_FuncTable.m_pfnGetFaceData(brush, faceNum);

			if( PointsEqual(faceA->m_v1, faceA->m_v2) ||
				PointsEqual(faceA->m_v2, faceA->m_v3) ||
				PointsEqual(faceA->m_v3, faceA->m_v1))
			{
				sprintf (message, "Null face found on brush #%d, killing.\n", brushNum);
				g_FuncTable.m_pfnSysMsg ( message );
				killBrush = 1;
				break;
			}
		}
		if(killBrush)
		{
			_QERDeleteBrushHandle (brush);
			brushesRemoved++;
		}
	}

	Sys_Printf ("%d evil polys purged.", brushesRemoved);
	g_FuncTable.m_pfnReleaseActiveBrushHandles();
}

/*
================
RemoveDuplicatePlanes
================
*/
void RemoveDuplicatePlanes (void)
{
	brush_t		*brush;
	_QERFaceData	faceA, faceB, *facePtr;
	int			faceAindex, faceBindex;
	qboolean	brushChanged;
	int			facesRemoved;
	int			brushNum;
	int			brushCount, faceCount;
	char		message[256];

	g_FuncTable.m_pfnAllocateActiveBrushHandles();
	brushCount = g_FuncTable.m_pfnActiveBrushCount();

	facesRemoved = 0;
	brushNum = 0;
	for (brushNum = 0 ; brushNum < brushCount; brushNum++)
	{
		brush = (brush_t *)g_FuncTable.m_pfnGetActiveBrushHandle(brushNum);
		brushChanged = 0;
		faceCount = g_FuncTable.m_pfnGetFaceCount(brush);
		for(faceAindex = 0; faceAindex < (faceCount-1); faceAindex++)
		{
			faceBindex = faceAindex + 1;
			facePtr = g_FuncTable.m_pfnGetFaceData(brush, faceAindex);
			if(facePtr)	
				memcpy (&faceA, facePtr, sizeof(_QERFaceData));
			facePtr = g_FuncTable.m_pfnGetFaceData(brush, faceBindex);
			if(facePtr)	
				memcpy (&faceB, facePtr, sizeof(_QERFaceData));
			while(facePtr)
			{
				if(FacesEqual(&faceA, &faceB))
				{
					brushChanged=1;
					facesRemoved++;
					g_FuncTable.m_pfnDeleteFace (brush, faceBindex);
					sprintf(message, "Removed face %d from brush %d\n", faceBindex, brushNum);
					g_FuncTable.m_pfnSysMsg ( message );
				}
				else		
					faceBindex++;	// only increment if we didn't remove that face and
									// we can count it.
	
				facePtr = g_FuncTable.m_pfnGetFaceData(brush, faceBindex);
				if(facePtr)
					memcpy (&faceB, facePtr, sizeof(_QERFaceData));
			}

			// since we may have removed them, get an updated count
			faceCount = g_FuncTable.m_pfnGetFaceCount(brush);
		}
		if (brushChanged)
		{
			g_FuncTable.m_pfnBuildBrush(brush);
		}
	}

	sprintf(message, "%d faces removed.\n", facesRemoved);
	g_FuncTable.m_pfnSysMsg ( message );
	g_FuncTable.m_pfnReleaseActiveBrushHandles();
}

// ================================
// ================================
#define SCAN_COUNT		1
#define SCAN_FIND		2

int ScanContents(int procedure)
{
	brush_t		*brush;
	_QERFaceData	faceA, faceB, *facePtr;
	face_t		*tempFace;
	vec3_t		centerPoint;
	int			contentCount;
	int			brushMixed;
	int			faceNum, faceCount, faceNum2;
	int			brushNum, brushCount;

	g_FuncTable.m_pfnAllocateActiveBrushHandles();
	brushCount = g_FuncTable.m_pfnActiveBrushCount();

	contentCount = 0;

	for (brushNum = 0; brushNum < brushCount; brushNum++)
	{
		brush = (brush_t *)g_FuncTable.m_pfnGetActiveBrushHandle(brushNum);
		brushMixed = 0;
		faceCount = g_FuncTable.m_pfnGetFaceCount(brush);
		for(faceNum = 0; faceNum < (faceCount-1); faceNum++)
		{
			facePtr = g_FuncTable.m_pfnGetFaceData(brush, faceNum);
			if(facePtr)	
				memcpy (&faceA, facePtr, sizeof(_QERFaceData));
			
			for(faceNum2=faceNum+1; faceNum2 < faceCount; faceNum2++)
			{
				facePtr = g_FuncTable.m_pfnGetFaceData(brush, faceNum2);
				if(facePtr)	
					memcpy (&faceB, facePtr, sizeof(_QERFaceData));

				if(faceA.m_nContents != faceB.m_nContents)
				{
					brushMixed = 1;

					if(procedure == SCAN_FIND)
					{
						faceNum = 0;
						Sys_Printf("Content Report:\n");
						for(tempFace = brush->brush_faces; tempFace; tempFace = tempFace->next)
						{
							Sys_Printf("Face %d, Contents: %x\n", faceNum, tempFace->texdef.contents);
							faceNum++;
						}
						Sys_Printf("\n");
					
						g_FuncTable.m_pfnDeselectAllBrushes();
						g_FuncTable.m_pfnSelectBrush(brush);

						centerPoint[0] = (brush->maxs[0] + brush->mins[0]) / 2;
						centerPoint[1] = (brush->maxs[1] + brush->mins[1]) / 2;
						centerPoint[2] = (brush->maxs[2] + brush->mins[2]) / 2;

						g_FuncTable.m_pfnPositionView (centerPoint, vec3_origin);

						return 1;
					}

				}
			}
		}

		if(brushMixed)
			contentCount++;				
	}				

	return contentCount;
}

void CountContents(void)
{
	int			mixCount;
	char		message[256];

	mixCount = ScanContents(SCAN_COUNT);

	sprintf(message, "%d brushes with mixed contents.\n", mixCount);
	g_FuncTable.m_pfnSysMsg ( message );

}

void FindContents(void)
{
	int			mixCount;
	char		message[256];

	mixCount = ScanContents(SCAN_COUNT);

	if(ScanContents(SCAN_FIND))
	{
		sprintf(message, "Total brushes with mixed contents: %d\n", ScanContents(SCAN_COUNT));
		g_FuncTable.m_pfnSysMsg ( message );
		sprintf(message, "Brush with mixed contents selected.\n");
		g_FuncTable.m_pfnSysMsg ( message );
	}
	else
	{
		sprintf (message, "No Brushes with mixed contents found.\n");
		g_FuncTable.m_pfnSysMsg ( message );
	}
}

BOOL CALLBACK AboutDlgProc( HWND hwndDlg,
						    UINT uMsg,
						    WPARAM wParam,
						    LPARAM lParam )
{
	switch (uMsg)
    {
	case WM_INITDIALOG:
		return TRUE;

	case WM_CLOSE:
		EndDialog( hwndDlg, 1 );
		return TRUE;

	case WM_COMMAND:
		if ( LOWORD( wParam ) == IDOK )
			EndDialog(hwndDlg, 1);
		return TRUE;
	}
	return FALSE;
}

// vMin/vMax provide the bounds of the selection, they are zero if there is no selection
// if there is a selection, bSingleBrush will be true if a single brush is selected
// if so, typical plugin behaviour (such as primitive creation) would use the bounds as
// a rule to create the primitive, then delete the selection
// FIXME: pretty lame ass.. fixup before releasing.. 
void WINAPI QERPlug_Dispatch(LPCSTR p, vec3_t vMin, vec3_t vMax, BOOL bSingleBrush)
{
	ASSERT(TableIsValid());

	if(!strcmp(p, "Purge Evil Polys"))
	{
		PurgeEvilPolys();
	}
	else if(!strcmp(p, "Remove Duplicate Planes"))
	{
		RemoveDuplicatePlanes();
	}
	else if(!strcmp(p, "Count Mixed Contents"))
	{
		CountContents();
	}
	else if(!strcmp(p, "Find Mixed Contents"))
	{
		FindContents();
	}
	else if(!strcmp(p, "About..."))
	{
		CDialog	myAboutDlg(IDD_ABOUT, NULL);

		myAboutDlg.DoModal();
	}

}
