	'' Command line parameters reader

	NAMESPACE comLine
		DIM AS    opt_t PTR cmd       ' every parameter
		DIM AS UINTEGER     numCmds   ' how many parameters

		''
		'' Setup new parameter
		''
		PRIVATE SUB setup (BYREF Label AS STRING, BYREF SomePtr AS ANY PTR, BYREF ParamList AS STRING, BYREF Message AS STRING, BYVAL Multiple AS INTEGER = 0)
			DIM AS    UBYTE PTR  xPtr   = ANY
			DIM AS    opt_t PTR  opt    = ANY
			DIM AS UINTEGER      i      = ANY
			DIM AS UINTEGER      j      = any
			DIM AS   STRING      Label2 = "-"

			ptrCreate(cmd, numCmds, numCmds + 1)
			opt = @cmd[numCmds]

			'' Full label, shorthand and help
			ptrZString(opt->cmdFull, TRIM(Label))
			xPtr = CPTR(UBYTE PTR, STRPTR(Label))
			FOR i = 0 TO (LEN(Label) - 1)
				IF ((xPtr[i] >= &h41) AND (xPtr[i] <= &h5A)) OR ((xPtr[i] >= &h30) AND (xPtr[i] <= &h39)) THEN Label2 += CHR(xPtr[i])
			NEXT i
			ptrZString(opt->cmdShort, Label2)
			ptrZString(opt->cmdHelp, TRIM(Message))

			'' Parameter is switch
			IF (ParamList = STR(VAL(ParamList))) THEN
				opt->cmdFlags  = cmdSwitch
				IF (Multiple) THEN opt->cmdFlags OR= cmdAllowMultiple
				opt->rndPointer  = SomePtr
				opt->rndValue    = VAL(ParamList)
				numCmds += 1
				EXIT SUB
			END IF

			'' Parameter takes arguments
			opt->cmdFlags    = 0
			IF (Multiple) THEN opt->cmdFlags OR= cmdAllowMultiple
			opt->rndPointer  = SomePtr

			if (len(ParamList)) then
				opt->rndValue    = 1
				xPtr = CPTR(UBYTE PTR, STRPTR(ParamList))
				FOR i = 0 TO LEN(ParamList) - 1
					opt->rndValue -= (xPtr[i] = &h20)
				NEXT i
				ptrZString(opt->cmdList, ParamList)
				xPtr = CPTR(UBYTE PTR, opt->cmdList)
				FOR i = 0 TO len(*opt->cmdList) - 1
					IF (xPtr[i] = &h20) THEN xPtr[i] = &h00
				NEXT i
			end if
			numCmds += 1
		END SUB

		''
		'' Print command (highlight capital letters, show arguments)
		''
		PRIVATE SUB PrintCommand(BYREF cmdPtr AS opt_t PTR, BYREF prefix AS STRING, BYREF suffix AS STRING)
			DIM AS UINTEGER     i     = ANY
			DIM AS UINTEGER     ofs   = ANY
			DIM AS    UBYTE PTR xPtr  = ANY

			COLOR 7: ? prefix;
			xPtr = CPTR(UBYTE PTR, cmdPtr->cmdFull)
			FOR i = 0 TO (LEN(*cmdPtr->cmdFull) - 1)
				IF ((xPtr[i] >= &h41) AND (xPtr[i] <= &h5A)) OR ((xPtr[i] >= &h30) AND (xPtr[i] <= &h39) or (i = 0)) THEN COLOR 15 ELSE COLOR 7
				? CHR(xPtr[i]);
			NEXT i
			IF ((cmdPtr->cmdFlags AND cmdSwitch) = 0) THEN
				COLOR 8: ofs = 0
				if (cmdPtr->rndValue) then
					FOR i = 0 TO cmdPtr->rndValue - 1
						? " <" + cmdPtr->cmdList[ofs] + ">";
						ofs += LEN(cmdPtr->cmdList[ofs]) + 1
					NEXT i
				end if
			END IF
			COLOR 7: ? suffix;
		END SUB

		''
		'' Display usage
		''
		PRIVATE SUB Usage()
			DIM AS   UBYTE PTR xPtr     = ANY
			DIM AS INTEGER     printMax = 0
			DIM AS INTEGER     printNow = ANY
			DIM AS INTEGER     i        = ANY
			DIM AS INTEGER     j        = ANY
			DIM AS INTEGER     ofs      = ANY
			DIM AS  STRING     appName  = ""

			'' Get application name
			appName = UCASE(COMMAND(0))
			IF (RIGHT(appName, 4) <> ".EXE") THEN appName += ".EXE"
			xPtr = CPTR(UBYTE PTR, STRPTR(appName))
			FOR i = 0 TO (LEN(appName) - 1)
				IF ((xPtr[LEN(appName) - 1 - i] = &h2F) OR (xPtr[LEN(appName) - 1 - i] = &h5C)) THEN EXIT FOR
			NEXT i
			? "Syntax: " + RIGHT(appName, i) + " [Commands]": ?

			'' Get longest command
			FOR i = 0 TO (numCmds - 1)
				WITH cmd[i]
					printNow = LEN(*.cmdFull)
					IF ((.cmdFlags AND cmdSwitch) = 0) THEN
						ofs = 0
						FOR j = 0 TO .rndValue - 1
							printNow += (LEN(.cmdList[ofs]) + 4)
							ofs += (LEN(.cmdList[ofs]) + 1)
						NEXT j
					END IF
				END WITH
				IF (printNow > printMax) THEN printMax = printNow
			NEXT i
			printMax += 2

			'' Print synthax
			FOR i = 0 TO (numCmds - 1)
				PrintCommand(@cmd[i], "   ", "")
				COLOR 15: ? TAB(printMax + 2); *cmd[i].cmdHelp
			NEXT i

			color 7
			SLEEP
		END SUB

		''
		'' Read command line
		''
		PRIVATE FUNCTION capture(byref cmds as strstk_t, BYVAL Ditch AS INTEGER = 0) AS INTEGER
			DIM   AS   opt_t PTR  opt     = ANY
			DIM   AS INTEGER      Count   = 0
			DIM   AS INTEGER      i       = ANY
			DIM   AS INTEGER      j       = ANY
			DIM   AS INTEGER      k       = ANY
			DIM   AS INTEGER      res     = ANY
			DIM   AS  STRING      thisCmd = ""
			REDIM AS  STRING      array()
			DIM                   tmpFunc AS FUNCTION(Array() AS STRING) AS INTEGER

      do until (count >= cmds.numIndices)
				thisCmd = *cmds.getByIndex(count)
				FOR i = 0 TO numCmds

					'' Parameter unknown
					IF (i = numCmds) THEN
						IF (LEFT(thisCmd, 1) = "-") THEN
							? "Parameter unknown: " + CHR(34) + thisCmd + CHR(34)
							function = cmdErr_UnknownParameter
						ELSE
							? "Lonely argument: " + CHR(34) + thisCmd + CHR(34)
							function = cmdErr_LonelyArgument
						END IF
						Count = 1: EXIT DO
					END IF

					'' Try parameter [i]
					opt = @cmd[i]
					IF (LCASE(thisCmd) <> LCASE(*opt->cmdFull)) AND (UCASE(thisCmd) <> *opt->cmdShort) THEN CONTINUE FOR	 ' Not the right parameter, keep searching
					IF (opt->cmdFlags AND cmdTriggered) THEN CONTINUE FOR ' Can't use this parameter mutliple times
					IF (opt->rndPointer = 0) THEN Usage(): count = 1: FUNCTION = 1: EXIT DO ' Display usage

					'' This parameter is a switch
					IF (opt->cmdFlags AND cmdSwitch) THEN
						*CPTR(UINTEGER PTR, opt->rndPointer) OR= opt->rndValue
						opt->cmdFlags OR= cmdTriggered
						EXIT FOR
					END IF

					'' This parameter takes arguments
					REDIM array(1 TO opt->rndValue)
					FOR j = 1 TO opt->rndValue
						Count += 1: array(j) = *cmds.getByIndex(count)
						IF (array(j) = "") THEN
							PrintCommand(opt, "Missing parameters: " + CHR(34), CHR(34))
							FUNCTION = cmderr_MissingParameter: COLOR 7: EXIT DO
						END IF
					NEXT j
					tmpFunc = opt->rndPointer
					res = tmpFunc(array())
					IF (res) THEN
						? *opt->cmdFull + ", value unknown/invalid"
						function = res: EXIT DO ' Function rejected parameters, something went wrong
					end if
					IF ((opt->cmdFlags AND cmdAllowMultiple) = 0) THEN opt->cmdFlags OR= cmdTriggered
					EXIT FOR
				NEXT i
				Count += 1
			LOOP

			ERASE array

			IF (Count = 0) THEN
				IF (Ditch = 0) THEN
					Usage(): return cmderr_ParametersRequired
				else
					RETURN 0
				end if
			END IF
		END FUNCTION

		''
		'' Asks user, multiple choices
		''
		PRIVATE FUNCTION Prompt(BYREF sMsg AS STRING, BYREF sList AS STRING) AS INTEGER
			DIM   AS  INTEGER     CurRow  = POS
			DIM   AS  INTEGER     CurLine = CSRLIN
			DIM   AS  INTEGER     i       = ANY
			DIM   AS   STRING     UserKey
			DIM   AS   STRING     TmpString
			REDIM AS   STRING *1  Choices(0 TO 0)

			IF (LEN(sList) = 0) THEN sList = "Yes/No"
			IF (RIGHT(sList,1) <> "/") THEN sList += "/"
			TmpString = sList
			DO
				FOR i = 1 TO LEN(TmpString)
					IF MID(TmpString, i, 1) = "/" THEN
						REDIM PRESERVE Choices(1 TO UBOUND(Choices) + 1)
						Choices(UBOUND(Choices)) = LCASE(LEFT(TmpString, 1))
						TmpString = RIGHT(TmpString, LEN(TmpString) - i)
						EXIT FOR
					END IF
				NEXT i
			LOOP WHILE LEN(TmpString)
			CurLine = CSRLIN: LOCATE CurLine,CurRow: ? sMsg+"? ["+LEFT(sList, LEN(sList) - 1)+"]";
			DO
				UserKey = LCASE(INKEY)
				FOR i = LBOUND(Choices) TO UBOUND(Choices)
					IF (UserKey <> Choices(i)) THEN CONTINUE FOR
					LOCATE CurLine, CurRow
					? SPACE(LEN(sMsg) + LEN(sList) + 4);
					LOCATE CurLine, CurRow
					ERASE Choices: RETURN i
				NEXT i
			LOOP
		END FUNCTION

		''
		'' Tests existence of specified filename, asks user before deleting
		''
		PRIVATE FUNCTION Overwrite (BYREF sFilename AS STRING, BYREF Variable AS INTEGER PTR, BYREF FlagValue AS INTEGER) AS INTEGER
			DIM AS   STRING UserEntry = ""
			DIM AS  INTEGER UserSaid  = ANY

			IF (DIR(sFilename, 32) = "") THEN RETURN -1 ' no file found, "yes, overwrite"
			IF (Variable) ANDALSO (FlagValue) THEN _
				IF (*Variable AND FlagValue) THEN KILL sFilename: RETURN -1 ' overwrite flag is on in this variable, "yes, overwrite"

			UserSaid = Prompt(CHR(34) + sFilename + CHR(34) + " already exists, replace", "Yes/No/Always")
			IF (UserSaid = 1) THEN KILL sFilename: RETURN -1
			IF (UserSaid = 2) THEN RETURN 0
			IF (UserSaid = 3) THEN *Variable OR= FlagValue: KILL sFilename: RETURN -1
		END FUNCTION

		''
		'' Convert time to readable string
		''
		PRIVATE SUB TimeString (BYVAL fTime AS DOUBLE = 0, BYREF sOut AS STRING)
			sOut = ""
			IF (fTime >= 86400) THEN sOut += STR(fTime \ 86400) + " D ": fTime MOD= 86400
			IF (fTime >= 3600 ) THEN sOut += STR(fTime \ 3600)  + " h ": fTime MOD= 3600
			IF (fTime >= 60   ) THEN sOut += STR(fTime \ 60)    + " m ": fTime MOD= 60
			if (instr(str(fTime), ".")) then
				sOut += left(STR(fTime), instr(str(fTime), ".") + 2) + " s"
			else
				sOut += STR(fTime) + " s"
			end if
		END SUB

		''
		'' Returns -1 if the provided name (AnyStr) matches the mask (Mask), 0 otherwise
		''
		PRIVATE FUNCTION match(BYREF Mask AS STRING, BYREF AnyStr AS STRING) AS INTEGER
			DIM AS INTEGER      chrMask = ANY, chrSrc = ANY, count = 0, cntTwo = ANY, i = ANY
			DIM AS INTEGER      lenMask = LEN(Mask),   lenSrc = LEN(AnyStr)
			DIM AS STRING       cpyMask = LCASE(Mask), cpySrc = LCASE(AnyStr)
			DIM AS zstring PTR  ptrMask = STRPTR(cpyMask), ptrSrc = STRPTR(cpySrc)

			IF ((lenMask = 0) ORELSE (lenSrc = 0)) THEN RETURN 0

			FOR i = 0 TO lenMask - 1
				chrMask = ptrMask[i]
				chrSrc  = ptrSrc[count]
				IF (chrMask = 42) THEN
					IF (i = lenMask - 1) THEN RETURN -1 ' if we made it so far, we're good!
					chrMask = ptrMask[i + 1]
					cntTwo = INSTR(count + 1, cpySrc, CHR(chrMask))
					IF (cntTwo = 0) THEN RETURN 0 ELSE count = cntTwo - 1
				ELSE
					IF ((chrMask = chrSrc) ORELSE (chrMask = 63)) THEN count += 1 ELSE RETURN 0
				END IF
			NEXT i
			RETURN -1
		END FUNCTION

		''
		'' Normalize path string
		''
		PRIVATE SUB pathClean(BYREF sPath AS STRING, BYVAL iFileMode AS INTEGER = 0)
			DIM   AS    UBYTE PTR xPtr          = ANY
			DIM   AS UINTEGER     i             = ANY
			DIM   AS  INTEGER     Path_Current  = 0
			DIM   AS   STRING     Path_Copy     = sPath
			DIM   AS   STRING     pathDefault   = CURDIR
			REDIM AS   STRING     Path_Nodes(0 TO 0)

			IF (LEN(TRIM(sPath)) = 0) THEN sPath = "": EXIT SUB
			IF (INSTR("\/", RIGHT(Path_Copy, 1)) = 0) THEN Path_Copy += "/"

			'' normalize default path
			xPtr = CPTR(UBYTE PTR, STRPTR(pathDefault))
			FOR i = 0 TO LEN(pathDefault) - 1
				IF (xPtr[i] = &h5C) THEN xPtr[i] = &h2F
			NEXT i

			FOR i = 1 TO LEN(Path_Copy)
				IF INSTR("\/", MID(Path_Copy, i, 1)) THEN
					Path_Nodes(Path_Current) = TRIM(Path_Nodes(Path_Current))
					IF (Path_Nodes(Path_Current) = ".") THEN Path_Nodes(Path_Current) = "": CONTINUE FOR
					IF (Path_Nodes(Path_Current) = "..") AND (Path_Current > 0) THEN
						IF (Path_Nodes(Path_Current - 1) <> "..") THEN
							Path_Nodes(Path_Current) = ""
							Path_Current -= 1
							Path_Nodes(Path_Current) = ""
							CONTINUE FOR
						END IF
					END IF
					Path_Current += 1: REDIM PRESERVE Path_Nodes(0 TO UBOUND(Path_Nodes) + 1)
				ELSE
					Path_Nodes(Path_Current) += MID(Path_Copy, i, 1)
				END IF
			NEXT i: Path_Copy = ""

			FOR i = LBOUND(Path_Nodes) TO UBOUND(Path_Nodes)
				IF (Path_Nodes(i) = "") OR (Path_Nodes(i) = ".") THEN CONTINUE FOR
				Path_Copy += Path_Nodes(i) + "/"
			NEXT i: ERASE Path_Nodes
			IF (iFileMode AND Path_IsFile) THEN Path_Copy = LEFT(Path_Copy, LEN(Path_Copy) - 1)
			sPath = TRIM(Path_Copy)
			IF (iFileMode AND Path_Absolute) THEN _
				IF (MID(sPath, 2, 1) <> ":") THEN sPath = pathDefault + "/" + sPath
		END SUB

		''
		'' Create specified directory if it doesn't exist
		''
		PRIVATE SUB pathCreate (BYREF sPath AS STRING)
			DIM AS  INTEGER     i       = ANY
			DIM AS   STRING     SrcCpy  = sPath

			pathClean(SrcCpy, Path_IsFolder)
			FOR i = 1 TO LEN(SrcCpy)
				IF (MID(SrcCpy, i, 1) = "/") THEN _
					IF (DIR(MID(SrcCpy, 1, i - 1), 16) = "") THEN MKDIR(MID(SrcCpy, 1, i - 1))
			NEXT i
			IF (DIR(SrcCpy, 16) = "") THEN MKDIR(SrcCpy)
		END SUB

		''
		'' Remove path from a string
		''
		PRIVATE SUB pathStrip(BYREF sSource AS STRING, BYREF sFilename AS STRING, BYREF sPath AS STRING)
			IF INSTR(sSource, "/") THEN
				sPath = LEFT(sSource, INSTRREV(sSource, "/"))
				sFilename = RIGHT(sSource, LEN(sSource) - LEN(sPath))
			ELSE
				sPath = "": sFilename = sSource
			END IF
		END SUB

		''
		'' Free memory (destructor)
		''
		PRIVATE SUB FreeMemory () DESTRUCTOR
			DIM AS UINTEGER     i   = ANY
			DIM AS    opt_t PTR opt = ANY

			IF (numCmds = 0) THEN EXIT SUB
			FOR i = 0 TO (numCmds - 1)
				opt = @cmd[i]
				ptrDestroy(opt->cmdFull)
				ptrDestroy(opt->cmdShort)
				ptrDestroy(opt->cmdList)
				ptrDestroy(opt->cmdHelp)
				opt->rndPointer = 0
				opt->rndValue   = 0
				opt->cmdFlags   = 0
			NEXT i
			numCmds = 0
		END SUB
	END NAMESPACE
