' This code is nothing short of a dirty hack
' Lightmaps may, in some occasion, get worse after rescale. Use KPRAD to recompile the map,
' use this program again if you need to correct the lighting gamma/brightness.

#DEFINE uint32  uinteger
#DEFINE  int32  integer
#DEFINE uint16  ushort
#DEFINE  int16  short
#DEFINE  uint8  ubyte
#DEFINE  float  single

        #DEFINE prog_ReplaceAll     &h1000
        #DEFINE prog_ForceRTLights  &h0001
        #DEFINE prog_ForceJunior    &h0002
        #DEFINE prog_ForceNoJunior  &h0004
        #DEFINE prog_ForceSpawnflag &h0008
        #DEFINE prog_ChangeEntities &h0010
        #DEFINE prog_KillEntities   &h0020
        #INCLUDE "!mem.bi"
        #INCLUDE "!cmd.bi"
        #INCLUDE "!string.bi"
        NAMESPACE prog
          DIM AS  ZSTRING ptr sourceFile    = 0
          DIM AS  ZSTRING ptr targetFile    = 0
          DIM AS   SINGLE     scale         = 1.00
          DIM AS   DOUBLE     gamma         = 1.00
          DIM AS  integer     offset        = 0
          DIM AS UINTEGER     settings      = 0
        END NAMESPACE
        #INCLUDE "_cmd.bi"
        #INCLUDE "_string.bi"

#DEFINE lpEntities    0
#DEFINE lpPlanes      1
#DEFINE lpVertices    2
#DEFINE lpVisibility  3
#DEFINE lpNodes       4
#DEFINE lpTexInfo     5
#DEFINE lpFaces       6
#DEFINE lpLightmaps   7
#DEFINE lpLeaves      8
#DEFINE lpLeafFace    9
#DEFINE lpLeafBrush   10
#DEFINE lpEdges       11
#DEFINE lpFaceEdges   12
#DEFINE lpModels      13
#DEFINE lpBrushes     14
#DEFINE lpBrushSides  15
#DEFINE lpPop         16
#DEFINE lpAreas       17
#DEFINE lpAreaPortals 18

#DEFINE	SURF_SKY		  &h04
#DEFINE	SURF_WARP	  	&h08
#DEFINE	SURF_TRANS33	&h10
#DEFINE	SURF_TRANS66	&h20

#MACRO vectorMulti(v, s)
v.x = v.x * s
v.y = v.y * s
v.z = v.z * s
#ENDMACRO

TYPE image_t
  AS    uint32 PTR buffer
  AS    uint32     w
  AS    uint32     h
  AS    uint32     s
  AS    uint32     ofs
  DECLARE SUB create(BYREF w AS INTEGER, BYREF h AS INTEGER)
  DECLARE SUB destroy()
END TYPE

TYPE bspFLump_t FIELD = 1
  AS uint32     offset
  AS uint32     length
  AS  uint8 PTR buffer
END TYPE

TYPE bspFile_t FIELD = 1
  AS     uint32     magic
  AS     uint32     version
  AS bspFLump_t PTR lump
  AS   UINTEGER     numLightmaps  ' extra
  AS    image_t PTR lightmap      ' extra
  DECLARE SUB      initialize ()
  DECLARE SUB      destroy    ()
  DECLARE FUNCTION loadFrom   (BYREF filename AS zstring PTR) AS INTEGER
  DECLARE FUNCTION saveTo     (BYREF filename AS zstring PTR) AS INTEGER
END TYPE

TYPE point3f_t FIELD = 1
  AS float x
  AS float y
  AS float z
END TYPE

TYPE point3s_t FIELD = 1
  AS int16 x
  AS int16 y
  AS int16 z
END TYPE

TYPE bspFace_t FIELD = 1
  AS uint16 plane
  AS uint16 plane_side
  AS uint32 first_edge
  AS uint16 num_edges
  AS uint16 texture_info
  AS uint32 lightmap_styles
  AS uint32 lightmap_offset
END TYPE

TYPE bspPlane_t FIELD = 1
  AS point3f_t normal
  AS     float distance
  AS    uint32 planetype
END TYPE

TYPE bspNode_t FIELD = 1
  AS    uint32 plane
  AS     int32 front_child
  AS     int32 back_child
  AS point3s_t bbox_min
  AS point3s_t bbox_max
  AS    uint16 first_face
  AS    uint16 num_faces
END TYPE

TYPE bspLeaf_t FIELD = 1
  AS    uint32 brush_or
  AS    uint16 cluster
  AS    uint16 area
  AS point3s_t bbox_min
  AS point3s_t bbox_max
  AS    uint16 first_leaf_face
  AS    uint16 num_leaf_faces
  AS    uint16 first_leaf_brush
  AS    uint16 num_leaf_brushes
END TYPE

TYPE bspModel_t FIELD = 1
  AS point3f_t mins
  AS point3f_t maxs
  AS point3f_t origin
  AS     int32 headnode
  AS     int32 firstface
  AS     int32 numfaces
END TYPE

TYPE bspTexInfo_t FIELD = 1
  AS point3f_t u_axis
  AS     float u_offset
  AS point3f_t v_axis
  AS     float v_offset
  AS    uint32 flags
  AS    uint32 value
  AS STRING*31 texture_name
  AS    uint32 next_texinfo
END TYPE

TYPE bspVisOffset_t FIELD = 1
  AS    uint32 pvs
  AS    uint32 phs
END TYPE
  

  ''
  '' math, floor() (there's no floor funtion in FreeBasic because fuck you)
  ''
  PRIVATE FUNCTION floor(BYVAL x AS SINGLE) AS INTEGER
    IF (FRAC(x)) THEN RETURN (FIX(x) + (x < 0))
    RETURN x
  END FUNCTION
  
  ''
  '' math, ceil() (there's no ceiling either)
  ''
  PRIVATE FUNCTION ceil(BYVAL x AS SINGLE) AS INTEGER
    IF (x < 0) THEN RETURN FIX(x)
    RETURN (FIX(x) - (FRAC(x) <> 0))
  END FUNCTION

  ''
  '' math, inrange (clamp)
  ''
  private function inrange(byval x as integer, byval max as integer) as integer
    if (x < 0) then
      return 0
    elseif (x > max) then
      return max
    end if
    return x
  end function


  ''
  '' Part of image_t (reserve memory and setup variables for image)
  ''
  PRIVATE SUB image_t.create(BYREF w AS INTEGER, BYREF h AS INTEGER)
    this.destroy()
    IF ((w = 0) OR (h = 0)) THEN EXIT SUB
    this.w = w
    this.h = h
    this.s = w * h
    ptrCreate(this.buffer, 0, s)
  END SUB
  
  ''
  '' Part of image_t (free memory and set variables to 0)
  ''
  PRIVATE SUB image_t.destroy()
    ptrDestroy(this.buffer)
    this.w = 0
    this.h = 0
    this.s = 0
  END SUB
    
  ''
  '' Part of bspFile_t (initialize structure; lump directory)
  ''
  PRIVATE SUB bspFile_t.initialize()
    this.destroy()
    ptrCreate(this.lump, 0, 19)
  END SUB
  
  '' destroy structure
  PRIVATE SUB bspFile_t.destroy()
    this.magic = 0
    this.version = 0
    IF (this.lump) THEN
      FOR i AS INTEGER = 0 TO 18
        WITH (this.lump[i])
          ptrDestroy(.buffer)
        END WITH
      NEXT i
      ptrDestroy(this.lump)
    END IF
    IF (this.numLightmaps) THEN
      FOR i AS INTEGER = 0 TO this.numLightmaps - 1
        this.lightmap[i].destroy()
      NEXT i
      ptrDestroy(this.lightmap)
    END IF
  END SUB
  
  PRIVATE FUNCTION bspFile_t.saveTo(BYREF filename AS zstring PTR) AS INTEGER
    DIM AS INTEGER ff = FREEFILE
    DIM AS INTEGER offset = (2 * 4) + (8 * 19)
  
    ? "Writing " + CHR(34) + *filename + CHR(34) + "..."
    IF (ff = 0) THEN RETURN -2 ' no handle available
    IF (DIR(*filename, &h23) = "") THEN KILL *filename ' file already exists
    IF (OPEN(*filename FOR BINARY AS #ff)) THEN RETURN -4 ' general i/o error
    
    ' Reset lump offsets
    FOR i AS INTEGER = 0 TO 18
      this.lump[i].offset = offset
      offset += this.lump[i].length
    NEXT i
  
    ' Save file
    PUT #ff,, this.magic
    PUT #ff,, this.version
    FOR i AS INTEGER = 0 TO 18
      PUT #ff,, this.lump[i].offset
      PUT #ff,, this.lump[i].length
    NEXT i
    FOR i AS INTEGER = 0 TO 18
      PUT #ff,, *this.lump[i].buffer, this.lump[i].length
    NEXT i
    CLOSE #ff
    
    ' Okay
    RETURN 0
  END FUNCTION
  
  '' load from file
  PRIVATE FUNCTION bspFile_t.loadFrom(BYREF filename AS zstring PTR) AS INTEGER
    DIM AS INTEGER ff = FREEFILE
    
    ' load file
    ? "Loading " + CHR(34) + *filename + CHR(34) + "..."
    IF (this.lump = 0) THEN this.initialize()
    IF (filename = 0) THEN RETURN -1 ' no file specified
    IF (ff = 0) THEN RETURN -2 ' no handle available
    IF (DIR(*filename, &h23) = "") THEN RETURN -3 ' file no found
    IF (OPEN(*filename FOR BINARY AS #ff)) THEN RETURN -4 ' general i/o error
    IF (LOF(ff) = 0) THEN CLOSE #ff: RETURN -5 ' file is empty
  
    ' get header and directory
    GET #ff, , this.magic
    IF (this.magic <> &h50534249) THEN CLOSE #ff: RETURN -11 ' not a BSP
    GET #ff, , this.version
    IF (this.version <> 38) THEN CLOSE #ff: RETURN -12 ' unsupported version
    FOR i AS INTEGER = 0 TO 18
      WITH this.lump[i]
        GET #ff, , .offset
        GET #ff, , .length
        ptrCreate(.buffer, 0, .length)
      END WITH
    NEXT i
    
    ' get lumps
    FOR i AS INTEGER = 0 TO 18
      WITH this.lump[i]
        IF (.length = 0) THEN CONTINUE FOR
        GET #ff, .offset + 1, *.buffer, .length
      END WITH
    NEXT i
  
    ' done, everything went a-okay I guess?
    CLOSE #ff
    
    RETURN 0
  END FUNCTION
  
  ''
  '' Rescale info for most lumps (no lightmaps or entities here)
  ''
  PRIVATE SUB rescaleGeometry(byref bsp as bspFile_t, byref scale as single)
    dim as   bspFlump_t PTR lump        = ANY ' all purpose lump pointer
    DIM AS    point3f_t PTR vertex      = ANY ' vertices
    DIM AS bspTexInfo_t PTR texInfo     = ANY ' texture info
    DIM AS   bspModel_t PTR model       = ANY ' models
    DIM AS   bspPlane_t PTR plane       = ANY ' planes
    DIM AS    bspLeaf_t PTR leaf        = ANY ' leaves
    DIM AS    bspNode_t PTR node        = ANY ' nodes    
    DIM AS      INTEGER     numVertices = any ' vertices
    DIM AS      INTEGER     numInfos    = any ' texture info
    DIM AS      INTEGER     numModels   = any ' models
    DIM AS      INTEGER     numPlanes   = any ' planes
    DIM AS      INTEGER     numLeaves   = any ' leaves
    DIM AS      INTEGER     numNodes    = any ' nodes
    
    '' rescale vertices
    lump = @bsp.lump[lpVertices]
    numVertices = lump->length / SIZEOF(point3f_t)
    vertex = CPTR(point3f_t PTR, lump->buffer)
    FOR i AS INTEGER = 0 TO numVertices - 1
      vectorMulti(vertex[i], scale)
    NEXT i
    
    '' rescale textures
    lump = @bsp.lump[lpTexInfo]
    numInfos = lump->length / SIZEOF(bspTexInfo_t)
    texInfo = CPTR(bspTexInfo_t PTR, lump->buffer)
    FOR i AS INTEGER = 0 TO numInfos - 1
      WITH texInfo[i]
        vectorMulti(.u_axis, (1.00 / scale))
        vectorMulti(.v_axis, (1.00 / scale))
      END WITH
    NEXT i

    '' rescale models
    lump = @bsp.lump[lpModels]
    numModels = lump->length / SIZEOF(bspModel_t)
    model = CPTR(bspModel_t PTR, lump->buffer)
    FOR i AS INTEGER = 0 TO numModels - 1
      WITH model[i]
        vectorMulti(.mins, scale)
        vectorMulti(.maxs, scale)
        vectorMulti(.origin, scale)
      END WITH
    NEXT i

    '' rescale planes
    lump = @bsp.lump[lpPlanes]
    numPlanes = lump->length / SIZEOF(bspPlane_t)
    plane = CPTR(bspPlane_t PTR, lump->buffer)
    FOR i AS INTEGER = 0 TO numPlanes - 1
      WITH plane[i]
        .distance = .distance * scale
      END WITH
    NEXT i
    
    '' rescale leaves
    lump = @bsp.lump[lpLeaves]
    numLeaves = lump->length / SIZEOF(bspLeaf_t)
    leaf = CPTR(bspLeaf_t PTR, lump->buffer)
    FOR i AS INTEGER = 0 TO numLeaves - 1
      WITH leaf[i]
        vectorMulti(.bbox_min, scale)
        vectorMulti(.bbox_max, scale)
      END WITH
    NEXT i
    
    '' rescale nodes
    lump = @bsp.lump[lpNodes]
    numNodes = lump->length / SIZEOF(bspNode_t)
    node = CPTR(bspNode_t PTR, lump->buffer)
    FOR i AS INTEGER = 0 TO numNodes - 1
      WITH node[i]
        vectorMulti(.bbox_min, scale)
        vectorMulti(.bbox_max, scale)
      END WITH
    NEXT i
  END SUB
  
    
  PRIVATE SUB brkValStr(BYREF coordStr AS STRING, BYREF coordLst AS SINGLE PTR, BYREF coordCnt AS INTEGER)
    DIM AS    UBYTE PTR xPtr     = CPTR(UBYTE PTR, STRPTR(coordStr))
    DIM AS UINTEGER     coordLen = LEN(coordStr)
    DIM AS   STRING     coordCln = ""
    DIM AS   STRING     tmpStr   = ""
    DIM AS    UBYTE     curnt = ANY, prev = 32, extra = 0

    '' get a clean string
    FOR i AS INTEGER = 0 TO coordLen - 1
      curnt = xPtr[i]
      IF (curnt = &h09) THEN curnt = &h20
      IF ((curnt = &h20) AND (prev = &h20)) THEN CONTINUE FOR
      coordCln += CHR(curnt)
      prev = curnt
    NEXT i
    coordCln = TRIM(coordCln)
    IF (LEN(coordCln) = 0) THEN
      coordCnt = 0
      EXIT SUB
    END IF

    '' count spaces, allocate memory
    coordCnt = 1
    xPtr = CPTR(UBYTE PTR, STRPTR(coordCln))
    coordLen = LEN(coordCln)
    FOR i AS INTEGER = 0 TO coordLen - 1
      coordCnt -= (xPtr[i] = &h20)
    NEXT i
    ptrCreate(coordLst, 0, coordCnt)

    '' record each value
    FOR i AS INTEGER = 0 TO coordLen
      IF ((xPtr[i] = &h20) OR (i = coordLen)) THEN
        coordLst[extra] = VAL(tmpStr)
        tmpStr = ""
        extra += 1
        CONTINUE FOR
      END IF
      tmpStr += CHR(xPtr[i])
    NEXT i
  END SUB
  
  PRIVATE SUB checkEntity(BYREF entBuffer AS UBYTE PTR, BYREF entLength AS UINTEGER, BYREF scale AS SINGLE)
    DIM AS  ZSTRING PTR entString       = CPTR(ZSTRING PTR, entBuffer)
    DIM AS   SINGLE PTR coordLst        = 0
    DIM AS    UBYTE PTR xPtr            = ANY
    DIM AS   STRING     fKey            = ""
    DIM AS   STRING     fValue          = ""
    DIM AS   STRING     entNew          = ""
    DIM AS    UBYTE     entNeedJunior   = 0
    DIM AS    UBYTE     entNeedColor    = 0
    DIM AS    UBYTE     entForceJunior  = 0
    DIM AS UINTEGER     entOffset       = 0
    DIM AS  INTEGER     coordCnt        = ANY
    DIM AS   STRING     tempJunior      = ""
    
    DIM AS UINTEGER     entCount        = any
    DIM AS   STRING     entSource       = ""
    DIM AS   STRING     entTarget       = ""

    '' need to check if this is a light or not
    if (prog.settings AND prog_ForceRTLights) then
      entOffset = 0
      DO
        fKey = entString[entOffset]
        entOffset += LEN(fKey) + 1
        fValue = entString[entOffset]
        entOffset += LEN(fValue) + 1
        IF (fKey <> "classname") THEN CONTINUE DO
        entNeedJunior = (fValue = "light")
        EXIT DO
      LOOP WHILE (entOffset < entLength)
      entNeedColor   = entNeedJunior
      entForceJunior = entNeedJunior
    else
      entNeedColor = 0
      entNeedJunior = 0
      entForceJunior = 0
    end if

    '' force junior creation, we'll append the string later on if needed, just so the code doesn't look like complete shit (moderate shit is enough)
    tempJunior = chr(34) + "classname" + chr(34) + " " + chr(34) + "junior" + chr(34) + chr(&h0A)

    '' global scaling and classname swaps
    entOffset = 0
    DO
      fKey = entString[entOffset]
      entOffset += LEN(fKey) + 1
      fValue = entString[entOffset]
      entOffset += LEN(fValue) + 1
      
      IF (fKey = "classname") THEN
        
        '' remove juniors
        if (prog.settings and prog_ForceNoJunior) then
          if (fValue = "junior") then exit sub ' bail for juniors
        end if

        '' change entity
        if ((prog.settings and prog_ChangeEntities) or (prog.settings and prog_KillEntities)) then
          '' Global swap list
          restore entitySwapList
          read entCount
          for i as integer = 0 to entCount - 1
            read entSource
            read entTarget
            if (fValue = entSource) then
              if (prog.settings AND prog_KillEntities) then entLength = 0: exit sub
              '? "Replacing " + chr(34) + entSource + chr(34) + " by " + chr(34) + entTarget + chr(34)
              fValue = entTarget: exit for
            end if
          next i
          '' Last quick check
          IF (LEFT(fValue, 8) = "monster_") THEN exit sub ' bail for monsters
        end if
      ELSEIF ((fKey = "origin") OR (fKey = "lip") OR (fKey = "light") OR (fKey = "height") OR (fKey = "_spotpoint") OR (fKey = "_sun_target")) THEN
        brkValStr(fValue, coordLst, coordCnt)
        IF (coordCnt) THEN
          fValue = ""
          FOR j AS INTEGER = 0 TO coordCnt - 1
            IF (j) THEN fValue += " "
            fValue += STR(INT(coordLst[j] * scale))
          NEXT j
          ptrDestroy(coordLst)
          tempJunior += chr(34) + fKey + chr(34) + " " + chr(34) + fValue + chr(34) + chr(&h0A)
        END IF
      ELSEIF ((fKey = "spawnflags") ANDALSO (entNeedJunior)) THEN
        if ((prog.settings and prog_ForceJunior) = 0) then
          fValue = STR(VAL(fValue) OR &h08) ' Make the light dynamic (junior)
          entNeedJunior = 0
        end if
      ELSEIF ((fKey = "_color") ANDALSO (entNeedColor)) then
        tempJunior += chr(34) + fKey + chr(34) + " " + chr(34) + fValue + chr(34) + chr(&h0A)
        entNeedColor = 0  ' Found color, we shouldn't override that (junior)
      ELSEIF (fKey = "style") then
        tempJunior += chr(34) + fKey + chr(34) + " " + chr(34) + fValue + chr(34) + chr(&h0A)
      END IF
      entNew += CHR(34) + fKey + CHR(34) + " " + CHR(34) + fValue + CHR(34) + CHR(&h0A)
    LOOP WHILE (entOffset < entLength)

    '' Add a "spawnflags" field to this entity, we still need one
    IF ((entNeedJunior) ANDALSO ((prog.settings and prog_ForceJunior) = 0)) THEN
      entNew += CHR(34) + "spawnflags" + CHR(34) + " " + CHR(34) + "8" + CHR(34) + CHR(&h0A)
    END IF
    '' Add a "_color" field to this entity, we still need one
    if (entNeedColor) then
      IF ((prog.settings and prog_ForceJunior) = 0) THEN
        entNew += CHR(34) + "_color" + CHR(34) + " " + CHR(34) + "1.00 1.00 1.00" + CHR(34) + CHR(&h0A)
      end if
      tempJunior += CHR(34) + "_color" + CHR(34) + " " + CHR(34) + "1.00 1.00 1.00" + CHR(34) + CHR(&h0A)
    end if

    '' Final string
    entNew = "{" + CHR(&h0A) + entNew + "}" + CHR(&h0A)
    if ((prog.settings and prog_ForceJunior) ANDALSO (entForceJunior)) then entNew += "{" + chr(&h0A) + tempJunior + "}" + chr(&h0A)
    ptrDestroy(entBuffer)
    entLength = LEN(entNew)
    ptrCreate(entBuffer, 0, entLength + 1)
    xPtr = CPTR(UBYTE PTR, STRPTR(entNew))
    FOR i AS INTEGER = 0 TO entLength - 1
      entBuffer[i] = xPtr[i]
    NEXT i
  END SUB
  
  PRIVATE SUB scaleEntities(BYREF lump AS bspFLump_t, BYREF scale AS SINGLE)
    DIM AS    UBYTE     inQuotes  = 0
    DIM AS    UBYTE     char      = ANY
    DIM AS    UBYTE     null      = &h00 '&h2A
    
    DIM AS UINTEGER     entStart  = ANY
    DIM AS UINTEGER     entStop   = ANY
    DIM AS UINTEGER     entLength = ANY
    DIM AS UINTEGER     entOffset = ANY
    DIM AS    UBYTE PTR entBuffer = 0
    
    DIM AS    UBYTE PTR tBuffer   = 0
    DIM AS UINTEGER     tLength   = 0
    DIM AS UINTEGER     tMax      = 150000 ' 150kb should be more than enough... Damn I'm lazy
    
    '' reserve memory for target buffer
    ptrCreate(tBuffer, 0, tmax)
    
    '' parse the whole string, look for individual entities
    FOR i AS INTEGER = 0 TO lump.length - 1
      IF ((lump.buffer[i] = &h7B) AND (inQuotes = 0)) THEN
        entStart = i
      ELSEIF ((lump.buffer[i] = &h7D) AND (inQuotes = 0)) THEN
        entStop    = i
        entLength  = entStop - entStart + 1
        ptrCreate(entBuffer, 0, entLength + 1)
        entOffset  = 0 
        FOR j AS INTEGER = 0 TO entLength - 1
          char = lump.buffer[entStart + j]
          IF ((inQuotes = 0) AND (char = &h22) AND (lump.buffer[entStart + j - 1] <> &h5C)) THEN inQuotes = 1: CONTINUE FOR
          IF (inQuotes = 0) THEN CONTINUE FOR
          IF ((inQuotes = 1) AND (char = &h22) AND (lump.buffer[entStart + j - 1] <> &h5C)) THEN inQuotes = 0: char = null
          IF (char = &h0A) THEN char = null
          entBuffer[entOffset] = char
          entOffset += 1
          entLength = entOffset
        NEXT j
        '' modify entity
        checkEntity(entBuffer, entLength, scale)
        
        '' copy modified entity to target buffer
        if entLength then
          FOR j AS INTEGER = 0 TO entLength - 1
            tBuffer[tLength + j] = entBuffer[j]
          NEXT j
          tLength += entLength
        end if
        inQuotes = 0
        ptrDestroy(entBuffer)
      END IF
      IF ((lump.buffer[i] = &h22) AND (lump.buffer[i - 1] <> &h5C)) THEN inQuotes xor= 1
    NEXT i
    
    '' flush entity lump, replace with target buffer
    ptrDestroy(lump.buffer)
    lump.length = tLength + 1 ' the string needs to be null-terminated, the buffer was oversized so it should be safe.
    lump.buffer = tBuffer
  END SUB
  
  '' select face edge
  PRIVATE SUB getVertexForFaceEdge(BYREF edgeID AS INTEGER, BYREF src AS bspFile_t, BYREF v AS point3f_t)
    DIM AS   INTEGER     faceEdge = ANY
    DIM AS  UINTEGER PTR edge     = ANY
    DIM AS point3f_t PTR vertex   = ANY
    
    vertex   = CPTR(point3f_t PTR, src.lump[lpVertices].buffer)         ' vertex list
    edge     = CPTR(UINTEGER PTR,  src.lump[lpEdges].buffer)             ' edge list (two vertices per edge)
    faceEdge = CPTR(INTEGER PTR,   src.lump[lpFaceEdges].buffer)[edgeID] ' points to an edge in the edge list (negative values swap first and second vertex)
    
    IF (faceEdge < 0) THEN
      v = vertex[HIWORD(edge[-faceEdge])]
    ELSE
      v = vertex[LOWORD(edge[faceEdge])]
    END IF
  END SUB

  '' get UV texture coordinates
  PRIVATE SUB getUV(BYREF tex AS bspTexInfo_t PTR, BYREF vertex AS point3f_t, BYREF u AS SINGLE, BYREF v AS SINGLE)
    WITH vertex
      u = (.x * tex->u_axis.x) + (.y * tex->u_axis.y) + (.z * tex->u_axis.z) + tex->u_offset
      v = (.x * tex->v_axis.x) + (.y * tex->v_axis.y) + (.z * tex->v_axis.z) + tex->v_offset
    END WITH
  END SUB
  
  '' get lightmap size
  PRIVATE SUB getLightmapSize(BYREF src AS bspFile_t, BYREF face AS bspFace_t, BYREF w AS INTEGER, BYREF h AS INTEGER)
    DIM AS bspTexInfo_t PTR tex  = ANY
    DIM AS    point3f_t     pt
    DIM AS       SINGLE     u      = ANY, v      = ANY
    DIM AS       SINGLE     min_u  = ANY, min_v  = ANY
    DIM AS       SINGLE     max_u  = ANY, max_v  = ANY
  
    '' catch texture info
    tex = @CPTR(bspTexInfo_t PTR, src.lump[lpTexInfo].buffer)[face.texture_info]
    
    ' initial vertex
    getVertexForFaceEdge(face.first_edge, src, pt)
    getUV(tex, pt, min_u, min_v)
    max_u = min_u
    max_v = min_v
    
    ' every other vertex
    FOR j AS INTEGER = 1 TO face.num_edges - 1
      getVertexForFaceEdge(face.first_edge + j, src, pt)
      getUV(tex, pt, u, v)
      IF (u < min_u) THEN min_u = u
      IF (v < min_v) THEN min_v = v
      IF (u > max_u) THEN max_u = u
      IF (v > max_v) THEN max_v = v
    NEXT j

    ' lightmap size
    w = ceil(max_u / 16) - floor(min_u / 16) + 1
    h = ceil(max_v / 16) - floor(min_v / 16) + 1
  END SUB

  '' count lightmaps for face[faceID]
  PRIVATE FUNCTION getNumLightmaps(BYREF src AS bspFile_t, BYREF faceID AS INTEGER) AS INTEGER
    DIM AS    bspFace_t     face = CPTR(bspFace_t PTR, src.lump[lpFaces].buffer)[faceID]
    DIM AS bspTexInfo_t     tex  = CPTR(bspTexInfo_t PTR, src.lump[lpTexInfo].buffer)[face.texture_info]
    DIM AS        UBYTE PTR xPtr = CPTR(UBYTE PTR, @face.lightmap_styles)
    DIM AS     UINTEGER     cnt  = 0

    IF (tex.flags AND (SURF_SKY OR SURF_WARP OR SURF_TRANS33 OR SURF_TRANS66)) THEN RETURN cnt ' cannot have a lightmap
    FOR i AS INTEGER = 0 TO 3
      IF (xPtr[i] = 255) THEN EXIT FOR
      cnt += 1
    NEXT i
    RETURN cnt
  END FUNCTION
   
  '' image rescale, all-purpose code
  PRIVATE SUB imageRescale(BYREF source AS image_t, BYREF w AS INTEGER, BYREF h AS INTEGER, byref noFilter as integer)
    DIM AS image_t temp
     
    if ((w = source.w) AND (h = source.h)) then exit sub
    temp.create(w, h)
      
    '' Nearest
    if (noFilter) then
      DIM AS UINTEGER PTR xPtr1 = ANY
      DIM AS UINTEGER PTR xPtr2 = temp.buffer
    
      FOR y AS INTEGER = 0 TO temp.h - 1
        xPtr1 = @source.buffer[CINT((y / (temp.h - 1)) * (source.h - 1)) * source.w]
        FOR x AS INTEGER = 0 TO temp.w - 1
          *xPtr2 = xPtr1[CINT((x / (temp.w - 1)) * (source.w - 1))]
          xPtr2 += 1
        NEXT x
      NEXT y

    '' Bilinear-filtered
    ELSE
      DIM AS    UBYTE PTR pxl1 = ANY, pxl2 = ANY, pxl3 = ANY, pxl4 = ANY
      DIM AS    UBYTE PTR xPtr1 = ANY, xPtr2 = ANY
      DIM AS    UBYTE PTR channel = ANY
      DIM AS   DOUBLE     u = ANY, u_ratio = ANY, u_opposite = ANY
      DIM AS   DOUBLE     v = ANY, v_ratio = ANY, v_opposite = ANY
      DIM AS  INTEGER     x = ANY, y = ANY
      DIM AS  INTEGER     col1 = ANY, col2 = ANY, row1 = ANY, row2 = ANY
      
      FOR v1 AS INTEGER = 0 TO temp.h - 1
        v = (v1 / (temp.h - 1)) * source.h - 0.50
        y = floor(v)
        v_ratio = v - y
        v_opposite = 1 - v_ratio
        row1 = (inRange(y, source.h - 1) * source.w)
        row2 = (inRange(y + 1, source.h - 1) * source.w)
        FOR u1 AS INTEGER = 0 TO temp.w - 1
          u = (u1 / (temp.w - 1)) * source.w - 0.50
          x = floor(u)
          u_ratio = u - x
          u_opposite = 1 - u_ratio
          col1 = (inRange(x, source.w - 1))
          col2 = (inRange(x + 1, source.w - 1))
          pxl1 = CPTR(UBYTE PTR, @source.buffer[col1 + row1])
          pxl2 = CPTR(UBYTE PTR, @source.buffer[col2 + row1])
          pxl3 = CPTR(UBYTE PTR, @source.buffer[col1 + row2])
          pxl4 = CPTR(UBYTE PTR, @source.buffer[col2 + row2])
          channel = CPTR(UBYTE PTR, @temp.buffer[u1 + (v1 * temp.w)])
          FOR i AS INTEGER = 0 TO 3
            channel[i] = (pxl1[i] * u_opposite + pxl2[i] * u_ratio) * v_opposite + (pxl3[i] * u_opposite + pxl4[i] * u_ratio) * v_ratio
          NEXT i
        NEXT u1
      NEXT v1
    end if
  
    '' Trash source and swap with temporary image
    source.destroy()
    source = temp
  END SUB

  '' store lightmap for later use
  PRIVATE SUB storeLightMaps(BYREF src AS bspFile_t)
    DIM AS      INTEGER     numFaces  = src.lump[lpFaces].length / SIZEOF(bspFace_t)
    DIM AS      INTEGER     w = ANY, h = ANY
    DIM AS      INTEGER     lightmapID = 0
    DIM AS      INTEGER     nlm       = ANY
    DIM AS        UBYTE PTR xPtr      = ANY
    DIM AS        UBYTE PTR xPtr2     = ANY
    DIM AS        UBYTE PTR startAdr  = ANY
    DIM AS    bspFace_t PTR face      = CPTR(bspFace_t PTR, src.lump[lpFaces].buffer)
    DIM AS bspTexInfo_t PTR tex       = CPTR(bspTexInfo_t PTR, src.lump[lpTexInfo].buffer)

    '? "   numFaces:     " + STR(numFaces)

    '' count lightmaps & reserve memory
    src.numLightmaps = 0
    FOR i AS INTEGER = 0 TO numFaces - 1
      src.numLightmaps += getNumLightmaps(src, i)
    NEXT i
    ptrCreate(src.lightmap, 0, src.numLightmaps)
    ? "Storing " + str(src.numLightmaps) + " lightmap(s)"

    '' copy lightmaps
    FOR i AS INTEGER = 0 TO numFaces - 1
      ' get lightmap count
      nlm = getNumLightmaps(src, i)
      IF (nlm = 0) THEN CONTINUE FOR

      ' catch lightmap size
      getLightmapSize(src, face[i], w, h)

      ' store all lightmaps for give face
      xPtr     = CPTR(UBYTE PTR, @face[i].lightmap_styles)
      startAdr = @src.lump[lpLightmaps].buffer[face[i].lightmap_offset]
      FOR j AS INTEGER = 0 TO nlm - 1
        IF (xPtr[j] = 255) THEN EXIT FOR
        ' initialize lightmap
        src.lightmap[lightmapID].create(w, h)
        ' copy lightmap
        xPtr2 = startAdr
        FOR j AS INTEGER = 0 TO src.lightmap[lightmapID].s - 1
          src.lightmap[lightmapID].buffer[j] = rgba(xPtr2[2], xPtr2[1], xPtr2[0], 255)
          xPtr2 += 3
        NEXT j
        ' move to next
        startAdr   += (src.lightmap[lightmapID].s * 3)
        lightmapID += 1
      NEXT j
    NEXT i
  END SUB

  '' lightmap brightness offset
  PRIVATE SUB offsetsLightMaps(BYREF src AS bspFile_t)
    #DEFINE RED   0
    #DEFINE GREEN 1
    #DEFINE BLUE  2
    
    dim as      ubyte ptr pixel = any
    dim as bspFLump_t ptr lump  = @src.lump[lpLightmaps]
    dim as      ubyte     luma  = any, min = 255, max = 0
    dim as     double     norm  = any
    dim as    integer     tmp   = any

    if (prog.gamma) then
      #if 0
      '' Find min max
      for i as integer = 0 to lump->length - 1 step 3
        pixel = @lump->buffer[i]
        luma = int((cint(pixel[RED]) * .299)) + (cint(pixel[GREEN] *.587)) + (cint(pixel[BLUE] * .114))
        if (min > luma) then min = luma
        if (max < luma) then max = luma
      next i
  
      '' Normalize + gamma
      for i as integer = 0 to lump->length - 1 step 3
        pixel = @lump->buffer[i]
        luma = int((cint(pixel[RED]) * .299)) + (cint(pixel[GREEN] *.587)) + (cint(pixel[BLUE] * .114))
        for j as integer = 0 to 2
          norm = ((pixel[j] - min) * (255 / (max - min)))
          tmp = norm^(1 / prog.gamma)
          if (tmp < 0) then
            tmp = 0
          elseif (tmp > 255) then
            tmp = 255
          end if
          pixel[j] = tmp
        next j
      next i
      #else
      '' Gamma
      for i as integer = 0 to lump->length - 1 step 3
        pixel = @lump->buffer[i]
        for j as integer = 0 to 2
          tmp = pixel[j]^(1 / prog.gamma)
          if (tmp < 0) then
            tmp = 0
          elseif (tmp > 255) then
            tmp = 255
          end if
          pixel[j] = tmp
        next j
      next i      
      #endif
    end if
    
    if (prog.offset) then
      for i as integer = 0 to lump->length - 1
        tmp = cint(lump->buffer[i]) + prog.offset
        if (tmp < 0) then
          tmp = 0
        elseif (tmp > 255) then
          tmp = 255
        end if
        lump->buffer[i] = tmp
      next i
    end if
  end sub

  '' rescale lightmaps as needed
  PRIVATE SUB rescaleLightMaps(BYREF src AS bspFile_t)
    DIM AS      INTEGER     numFaces = src.lump[lpFaces].length / SIZEOF(bspFace_t)
    DIM AS    bspFace_t PTR face     = CPTR(bspFace_t PTR, src.lump[lpFaces].buffer)
    DIM AS        UBYTE PTR xPtr = any, xPtr2 = any
    DIM AS      INTEGER     nlm = ANY, w = ANY, h = ANY, ofst = 0, numLightmap = 0

    '' fix each surface
    FOR i AS INTEGER = 0 TO numFaces - 1
      ' get number of lightmaps for this face
      nlm = getNumLightmaps(src, i)
      IF (nlm = 0) THEN
        face[i].lightmap_offset = 0
        CONTINUE FOR
      END IF
      
      ' set face's initial lightmap
      face[i].lightmap_offset = ofst
      
      ' get face's lightmap size
      getLightmapSize(src, face[i], w, h)

      ' update every linked lightmap (dynamic lighting)
      FOR j AS INTEGER = 0 TO nlm - 1
        'imageRescale(src.lightmap[numLightmap], w, h, prog.settings AND prog_Nearest)
        imageRescale(src.lightmap[numLightmap], w, h, 1) ' for bilinear filtering
        src.lightmap[numLightmap].ofs = ofst
        ofst += (src.lightmap[numLightmap].s * 3)
        numLightmap += 1
      NEXT j
    NEXT i

    '' replace old lightmap chunk
    ? "Update lightmap chunk"
    ptrDestroy(src.lump[lpLightmaps].buffer)
    ptrCreate(src.lump[lpLightmaps].buffer, 0, ofst)
    src.lump[lpLightmaps].length = ofst
    FOR i AS INTEGER = 0 TO src.numLightmaps - 1
      IF (src.lightmap[i].s) THEN
        xPtr = @src.lump[lpLightmaps].buffer[src.lightmap[i].ofs]
        FOR j AS INTEGER = 0 TO src.lightmap[i].s - 1
          xPtr2 = cptr(ubyte ptr, @src.lightmap[i].buffer[j])
          xPtr[0] = xPtr2[0]
          xPtr[1] = xPtr2[1]
          xPtr[2] = xPtr2[2]
          xPtr += 3
        NEXT j
      END IF
    NEXT i
  END SUB


    
        PRIVATE FUNCTION setSource(array() AS STRING) AS INTEGER
          dim as string tmp = lcase(trim(array(1)))
          if (right(tmp, 4) = ".bsp") then tmp = left(tmp, len(tmp) - 4)
          ptrZString(prog.sourceFile, tmp + ".bsp")
          if (prog.targetFile = 0) then
            ptrZString(prog.targetFile, tmp + "_rescale.bsp")
          end if
          '? "setSource okay"
          RETURN 0
        END FUNCTION
        
        PRIVATE FUNCTION setTarget(array() AS STRING) AS INTEGER
          dim as string tmp = lcase(trim(array(1)))
          if (right(tmp, 4) <> ".bsp") then tmp += ".bsp"
          ptrZString(prog.targetFile, tmp)
          return 0
        END FUNCTION
        
        private function setScale(array() AS STRING) AS INTEGER
          if (val(array(1)) <= 0) then return -1
          prog.scale = val(array(1))
          return 0
        end function
        
        private function setRTLights(array() as string) as integer
          array(1) = lcase(array(1))
          prog.settings XOR= (prog.settings AND prog_ForceJunior)
          prog.settings XOR= (prog.settings AND prog_ForceSpawnflag)
          prog.settings XOR= (prog.settings AND prog_ForceNoJunior)
          if (array(1) = "spawnflag") then
            prog.settings OR= prog_ForceRTLights or prog_ForceSpawnflag
          elseif (array(1) = "junior") then  
            prog.settings OR= prog_ForceRTLights or prog_ForceJunior
          elseif (array(1) = "remove") then  
            prog.settings OR= prog_ForceRTLights or prog_ForceNoJunior
          else
            return 1
          end if
          return 0
        end function
        
        private function setLMGamma(array() as string) as integer
          prog.gamma = val(array(1))
          if (prog.gamma > 2) then
            prog.gamma = 2
          elseif (prog.gamma < 0) then
            prog.gamma = 0
          end if
          return 0
        end function
        
        private function setLMOffset(array() as string) as integer
          prog.offset = val(array(1))
          if (prog.offset > 255) then
            prog.offset = 255
          elseif (prog.offset < -255) then
            prog.offset = -255
          end if
          return 0
        end function
        
        PUBLIC FUNCTION main() AS INTEGER
          DIM AS bspFile_t myFile
          dim as   integer i
          dim as   integer lastErr
          
          '' init command line parameters
          comLine.setup("-In",          @setSource,         "source",                 "Source file (.BSP)")
          comLine.setup("-Out",         @setTarget,         "target",                 "Targer file (.BSP), optional")
          comLine.setup("-Scale",       @setScale,          "scale",                  "Rescale volumes, optional")
          comLine.setup("-RTLights",    @setRTLights,       "mode",                   "Real-time lights (spawnflag|junior|remove), optional")
          comLine.setup("-LMGamma",     @setLMGamma,        "gamma",                  "LightMap gamma, optional")
          comLine.setup("-LMOffset",    @setLMOffset,       "offset",                 "LightMap linear offset, optional")
          comLine.setup("-Entities",    @prog.settings,     STR(prog_ChangeEntities), "Convert Quake II entities to Kingpin, optional")
          comLine.setup("-EntKill",     @prog.settings,     STR(prog_KillEntities),   "Remove all pickup items, optional")
          comLine.setup("-Replace",     @prog.settings,     STR(prog_ReplaceAll),     "Always replace existing files")
      
          '' banner
          ? STRING(LOWORD(WIDTH), 196);
          ? Center ("Q2KPConv, version 0.8    2018 by ACC")
          ? Center ("YOU MAY DISTRIBUTE THIS PROGRAM FREE OF CHARGE.")
          ? Center ("A hundred bucks to whoever recognizes the layout I'm shamelessly ripping off.")
          ? STRING(LOWORD(WIDTH), 196)
          
          '' get command line parameters
          dim as strstk_t cmdList
          DO WHILE LEN(COMMAND(cmdList.numIndices + 1))
            cmdList.stack(command(cmdList.numIndices + 1), strForceStack)
          LOOP
          i = comLine.capture(cmdList, 0)
          cmdList.destroy()
          if (i) then return -1
      
          '' Load BSP
          lastErr = myFile.loadFrom(prog.sourceFile)
          if (lastErr) then
            myFile.destroy()
            ? "Something went wrong (code " + str(lastErr) + ")"
            RETURN lastErr
          END IF
          
          '' Rescale
          if (prog.scale <> 1.00) then
            ? iif(prog.scale < 1, "Downscaling", "Upscaling") + *prog.sourceFile + " to " + str(int(prog.scale * 100)) + "%"
            ? " :: Storing lightmaps"
            storeLightMaps(myFile)
            ? " :: Rescaling geometry"
            rescaleGeometry(myFile, prog.scale)
            ? " :: Rescaling lightmaps"
            rescaleLightMaps(myFile)
          end if

          if (prog.gamma) ORELSE (prog.offset) then
            ? "Tweaking LightMap brightness"
            offsetsLightMaps(myFile)
          end if

          if ((prog.scale <> 1.00) OR (prog.settings and prog_ChangeEntities) OR (prog.settings and prog_ForceRTLights)) then
            ? "Updating entities"
            scaleEntities(myFile.lump[lpEntities], prog.scale)
          end if
          
          '' Save BSP
          IF (comLine.Overwrite(*prog.targetFile, @Prog.settings, prog_ReplaceAll)) THEN myFile.saveTo(prog.targetFile)
          
          '' All done
          myFile.destroy()
          ? "All done."
          return 0
        END FUNCTION
      
        end main()
        
        SUB freeAll() DESTRUCTOR
          ptrDestroy(prog.targetFile)
          ptrDestroy(prog.sourceFile)
        END SUB

SLEEP
END

EntitySwapList:
  DATA 37
  DATA "ammo_bullets",           "ammo_cylinder",           "ammo_cells",           "ammo_308"
  DATA "ammo_grenades",          "ammo_grenades",           "ammo_rockets",         "ammo_rockets"
  DATA "ammo_shells",            "ammo_shells",             "ammo_slugs",           "ammo_flametank"

  DATA "item_armor_body",        "item_armor_helmet_heavy", "item_armor_combat",    "item_armor_legs_heavy"
  DATA "item_armor_jacket",      "item_armor_jacket_heavy", "item_armor_shard",     "item_health_sm"

  DATA "item_health",            "item_health_sm",          "item_health_large",    "item_health_lg"
  DATA "item_health_mega",       "item_adrenaline",         "item_health_small",    "item_health_sm"

  DATA "item_bandolier",         "item_pack",               "item_breather",        "item_health_sm"
  DATA "item_enviro",            "item_health_sm",          "item_invulnerability", "item_adrenaline"
  DATA "item_pack",              "item_pack",               "item_power_screen",    "item_armor_jacket_heavy"
  DATA "item_power_shield",      "item_armor_jacket_heavy", "item_quad",            "item_adrenaline"

  DATA "item_silencer",          "weapon_spistol"

  DATA "weapon_bfg",             "weapon_heavymachinegun",  "weapon_chaingun",      "weapon_tommygun"
  DATA "weapon_grenadelauncher", "weapon_grenadelauncher",  "weapon_hyperblaster",  "weapon_heavymachinegun"
  DATA "weapon_machinegun",      "weapon_tommygun",         "weapon_railgun",       "weapon_flamethrower"
  DATA "weapon_rocketlauncher",  "weapon_bazooka",          "weapon_shotgun",       "weapon_shotgun"
  DATA "weapon_supershotgun",    "weapon_shotgun"
