	'' Memory macros

	#MACRO ptrCreate( pSrc, pFrom, pTo )
	IF (pSrc = 0) THEN
		pSrc = CALLOCATE((pTo) * SIZEOF(TYPEOF(*pSrc)))
	ELSE
		IF (pTo > 0) AND (pFrom >= 0) THEN
			DIM AS TYPEOF(*pSrc) PTR pNew = REALLOCATE(pSrc, (pTo) * SIZEOF(TYPEOF(*pSrc)))
			IF (pNew) THEN
				pSrc = pNew
				IF ((pTo) > (pFrom)) THEN CLEAR pSrc[pFrom], 0, SIZEOF(TYPEOF(*pSrc)) * ((pTo) - (pFrom))
			END IF
		ELSE
			DEALLOCATE(pSrc): pSrc = 0
		END IF
	END IF
	#ENDMACRO

	#MACRO ptrZString( pSrc, cMsg )
	IF (LEN(cMsg)) THEN
		IF (pSrc) THEN
			DIM AS TYPEOF(*pSrc) PTR pNew
			pNew = CALLOCATE((LEN(cMsg) + 1) * SIZEOF(*pSrc))
			*pNew = cMsg: DEALLOCATE(pSrc): pSrc = pNew
		ELSE
			pSrc = CALLOCATE((LEN(cMsg) + 1) * SIZEOF(*pSrc))
			*pSrc = cMsg
		END IF
	ELSE
		IF (pSrc) THEN DEALLOCATE(pSrc): pSrc = 0
	END IF
	#ENDMACRO

	#MACRO ptrDestroy( pSrc )
	IF (pSrc) THEN DEALLOCATE(pSrc): pSrc = 0
	#ENDMACRO
